/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.server.OTokenHandler;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequestException;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.OHttpSession;
import com.orientechnologies.orient.server.network.protocol.http.OHttpSessionManager;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAbstract;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;

public abstract class OServerCommandAuthenticatedDbAbstract
extends OServerCommandAbstract {
    public static final char DBNAME_DIR_SEPARATOR = '$';
    public static final String SESSIONID_UNAUTHORIZED = "-";
    public static final String SESSIONID_LOGOUT = "!";
    private volatile OTokenHandler tokenHandler;

    @Override
    public boolean beforeExecute(OHttpRequest iRequest, OHttpResponse iResponse) throws IOException {
        OHttpSession currentSession;
        List authenticationParts;
        super.beforeExecute(iRequest, iResponse);
        this.init();
        String[] urlParts = iRequest.url.substring(1).split("/");
        if (urlParts.length < 2) {
            throw new OHttpRequestException("Syntax error in URL. Expected is: <command>/<database>[/...]");
        }
        iRequest.databaseName = URLDecoder.decode(urlParts[1], "UTF-8");
        if (iRequest.bearerTokenRaw != null) {
            try {
                iRequest.bearerToken = this.tokenHandler.parseWebToken(iRequest.bearerTokenRaw.getBytes());
            }
            catch (Exception e) {
                OLogManager.instance().warn((Object)this, "Bearer token parsing failed", (Throwable)e, new Object[0]);
            }
            if (iRequest.bearerToken == null || !iRequest.bearerToken.getIsVerified()) {
                this.sendAuthorizationRequest(iRequest, iResponse, iRequest.databaseName);
                return false;
            }
            this.tokenHandler.validateToken(iRequest.bearerToken, urlParts[0], urlParts[1]);
            if (!iRequest.bearerToken.getIsValid()) {
                OLogManager.instance().warn((Object)this, "Token '%s' is not valid for database '%s'", new Object[]{iRequest.bearerTokenRaw, iRequest.databaseName});
                this.sendAuthorizationRequest(iRequest, iResponse, iRequest.databaseName);
                return false;
            }
            return iRequest.bearerToken.getIsValid();
        }
        List list = authenticationParts = iRequest.authorization != null ? OStringSerializerHelper.split((String)iRequest.authorization, (char)':', (char[])new char[0]) : null;
        if (iRequest.sessionId != null && iRequest.sessionId.length() > 1) {
            currentSession = OHttpSessionManager.getInstance().getSession(iRequest.sessionId);
            if (currentSession != null && authenticationParts != null && !currentSession.getUserName().equals(authenticationParts.get(0))) {
                currentSession = null;
            }
        } else {
            currentSession = null;
        }
        if (currentSession == null) {
            if (iRequest.authorization == null || SESSIONID_LOGOUT.equals(iRequest.sessionId)) {
                iResponse.setSessionId(SESSIONID_UNAUTHORIZED);
                this.sendAuthorizationRequest(iRequest, iResponse, iRequest.databaseName);
                return false;
            }
            return this.authenticate(iRequest, iResponse, authenticationParts, iRequest.databaseName);
        }
        if (!currentSession.getDatabaseName().equals(iRequest.databaseName)) {
            OLogManager.instance().warn((Object)this, "Session %s is trying to access to the database '%s', but has been authenticated against the database '%s'", new Object[]{iRequest.sessionId, iRequest.databaseName, currentSession.getDatabaseName()});
            OHttpSessionManager.getInstance().removeSession(iRequest.sessionId);
            this.sendAuthorizationRequest(iRequest, iResponse, iRequest.databaseName);
            return false;
        }
        if (authenticationParts != null && !currentSession.getUserName().equals(authenticationParts.get(0))) {
            OLogManager.instance().warn((Object)this, "Session %s is trying to access to the database '%s' with user '%s', but has been authenticated with user '%s'", new Object[]{iRequest.sessionId, iRequest.databaseName, authenticationParts.get(0), currentSession.getUserName()});
            OHttpSessionManager.getInstance().removeSession(iRequest.sessionId);
            this.sendAuthorizationRequest(iRequest, iResponse, iRequest.databaseName);
            return false;
        }
        return true;
    }

    @Override
    public boolean afterExecute(OHttpRequest iRequest, OHttpResponse iResponse) throws IOException {
        ODatabaseRecordThreadLocal.instance().remove();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean authenticate(OHttpRequest iRequest, OHttpResponse iResponse, List<String> iAuthenticationParts, String iDatabaseName) throws IOException {
        ODatabaseDocument db = null;
        try {
            db = (ODatabaseDocument)this.server.openDatabase(iDatabaseName, iAuthenticationParts.get(0), iAuthenticationParts.get(1));
            iRequest.data.currentUserId = db.getUser() == null ? "<server user>" : db.getUser().getIdentity().toString();
            iResponse.sessionId = iRequest.sessionId = OHttpSessionManager.getInstance().createSession(iDatabaseName, iAuthenticationParts.get(0), iAuthenticationParts.get(1));
            boolean bl = true;
            return bl;
        }
        catch (OSecurityAccessException oSecurityAccessException) {
        }
        catch (OLockException e) {
            OLogManager.instance().error((Object)this, "Cannot access to the database '" + iDatabaseName + "'", (Throwable)e, new Object[0]);
        }
        finally {
            if (db == null) {
                this.sendAuthorizationRequest(iRequest, iResponse, iDatabaseName);
            } else {
                db.close();
            }
        }
        return false;
    }

    protected void sendAuthorizationRequest(OHttpRequest iRequest, OHttpResponse iResponse, String iDatabaseName) throws IOException {
        iRequest.sessionId = SESSIONID_UNAUTHORIZED;
        String header = this.server.getSecurity().getAuthenticationHeader(iDatabaseName);
        if (this.isJsonResponse(iResponse)) {
            this.sendJsonError(iResponse, 401, "Unauthorized", "text/plain", "401 Unauthorized.", header);
        } else {
            iResponse.send(401, "Unauthorized", "text/plain", "401 Unauthorized.", header);
        }
    }

    protected ODatabaseDocumentInternal getProfiledDatabaseInstance(OHttpRequest iRequest) throws InterruptedException {
        if (iRequest.bearerToken != null) {
            return this.getProfiledDatabaseInstanceToken(iRequest);
        }
        return this.getProfiledDatabaseInstanceBasic(iRequest);
    }

    protected ODatabaseDocumentInternal getProfiledDatabaseInstanceToken(OHttpRequest iRequest) throws InterruptedException {
        ODatabaseDocumentInternal localDatabase = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (localDatabase == null) {
            localDatabase = (ODatabaseDocumentTx)this.server.openDatabase(iRequest.databaseName, iRequest.bearerToken);
        } else {
            ORID currentUserId = iRequest.bearerToken.getUserId();
            if (currentUserId != null && localDatabase != null && localDatabase.getUser() != null && !currentUserId.equals(localDatabase.getUser().getDocument().getIdentity())) {
                ODocument userDoc = (ODocument)localDatabase.load(currentUserId);
                localDatabase.setUser((OSecurityUser)new OUser(userDoc));
            }
        }
        iRequest.data.lastDatabase = localDatabase.getName();
        iRequest.data.lastUser = localDatabase.getUser() != null ? localDatabase.getUser().getName() : null;
        return (ODatabaseDocumentTx)localDatabase.getDatabaseOwner();
    }

    protected ODatabaseDocumentInternal getProfiledDatabaseInstanceBasic(OHttpRequest iRequest) throws InterruptedException {
        OHttpSession session = OHttpSessionManager.getInstance().getSession(iRequest.sessionId);
        if (session == null) {
            throw new OSecurityAccessException(iRequest.databaseName, "No session active");
        }
        ODatabaseDocumentInternal localDatabase = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (localDatabase == null) {
            localDatabase = (ODatabaseDocumentTx)this.server.openDatabase(iRequest.databaseName, session.getUserName(), session.getUserPassword());
        } else {
            String currentUserId = iRequest.data.currentUserId;
            if (currentUserId != null && currentUserId.length() > 0 && localDatabase != null && localDatabase.getUser() != null && !currentUserId.equals(localDatabase.getUser().getIdentity().toString())) {
                ODocument userDoc = (ODocument)localDatabase.load((ORID)new ORecordId(currentUserId));
                localDatabase.setUser((OSecurityUser)new OUser(userDoc));
            }
        }
        iRequest.data.lastDatabase = localDatabase.getName();
        iRequest.data.lastUser = localDatabase.getUser() != null ? localDatabase.getUser().getName() : null;
        return (ODatabaseDocumentTx)localDatabase.getDatabaseOwner();
    }

    private void init() {
        if (this.tokenHandler == null && OGlobalConfiguration.NETWORK_HTTP_USE_TOKEN.getValueAsBoolean()) {
            this.tokenHandler = this.server.getTokenHandler();
        }
    }
}

