/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extdirect.model;

import com.google.common.base.Preconditions;
import java.util.List;

public class StoreLoadParameters {
    private Integer page;
    private Integer start;
    private Integer limit;
    private List<Sort> sort;
    private List<Filter> filter;
    private String query;
    private boolean formatSearch;

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public StoreLoadParameters filters(List<Filter> filter) {
        this.filter = filter;
        return this;
    }

    public StoreLoadParameters limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public StoreLoadParameters page(Integer page) {
        this.page = page;
        return this;
    }

    public StoreLoadParameters sort(List<Sort> sort) {
        this.sort = sort;
        return this;
    }

    public StoreLoadParameters start(Integer start) {
        this.start = start;
        return this;
    }

    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public List<Filter> getFilters() {
        return this.filter;
    }

    public void setFilter(List<Filter> filter) {
        this.filter = filter;
    }

    public String getFilter(String property) {
        Preconditions.checkNotNull((Object)property, (Object)"property");
        if (this.filter != null) {
            for (Filter item : this.filter) {
                if (!property.equals(item.getProperty())) continue;
                return item.getValue();
            }
        }
        return null;
    }

    public List<Sort> getSort() {
        return this.sort;
    }

    public void setSort(List<Sort> sort) {
        this.sort = sort;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<Filter> getFilter() {
        return this.filter;
    }

    public boolean isFormatSearch() {
        return this.formatSearch;
    }

    public void setFormatSearch(boolean formatSearch) {
        this.formatSearch = formatSearch;
    }

    public String toString() {
        return "StoreLoadParameters{page=" + this.page + ", start=" + this.start + ", limit=" + this.limit + ", sort=" + this.sort + ", filter=" + this.filter + ", formatSearch=" + this.formatSearch + '}';
    }

    public static class Filter {
        private String property;
        private String value;

        public String getProperty() {
            return this.property;
        }

        public Filter property(String property) {
            this.property = property;
            return this;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String getValue() {
            return this.value;
        }

        public Filter value(String value) {
            this.value = value;
            return this;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return "Filter{property='" + this.property + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    public static class Sort {
        private String property;
        private String direction;

        public Sort() {
        }

        public Sort(String property, String direction) {
            this.property = property;
            this.direction = direction;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String getDirection() {
            return this.direction;
        }

        public void setDirection(String value) {
            this.direction = value;
        }

        public String toString() {
            return "Sort{property='" + this.property + '\'' + ", direction='" + this.direction + '\'' + '}';
        }
    }
}

