/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extdirect.model;

import java.util.Collection;
import org.sonatype.nexus.extdirect.model.PagedResponse;

public class LimitedPagedResponse<T>
extends PagedResponse<T> {
    private long unlimitedTotal;
    private boolean limited;
    private boolean timedOut;

    public LimitedPagedResponse(long limit, long total, Collection<T> data) {
        super(Math.min(limit, total), data);
        this.unlimitedTotal = total;
        this.limited = total != this.getTotal();
    }

    public LimitedPagedResponse(long limit, long total, Collection<T> data, boolean timedOut) {
        this(limit, total, data);
        this.timedOut = timedOut;
    }

    public long getUnlimitedTotal() {
        return this.unlimitedTotal;
    }

    public boolean isLimited() {
        return this.limited;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }
}

