/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extdirect.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.subject.Subject;
import org.sonatype.nexus.extdirect.model.Response;

public class ErrorResponse
extends Response<Object> {
    private String message;
    private boolean authenticationRequired;

    public ErrorResponse(Throwable cause) {
        this(((Throwable)Preconditions.checkNotNull((Object)cause)).getMessage() == null ? cause.getClass().getName() : cause.getMessage());
        Subject subject;
        this.authenticationRequired = cause instanceof UnauthenticatedException;
        if (this.authenticationRequired && ((subject = SecurityUtils.getSubject()) == null || !subject.isRemembered() && !subject.isAuthenticated())) {
            this.message = "Access denied (authentication required)";
        }
    }

    public ErrorResponse(String message) {
        super(false, Lists.newArrayList());
        this.message = (String)Preconditions.checkNotNull((Object)message);
    }
}

