/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extdirect.internal;

import com.google.common.collect.Maps;
import com.google.inject.servlet.ServletModule;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.extdirect.internal.ExtDirectGsonBuilderConfigurator;
import org.sonatype.nexus.extdirect.internal.ExtDirectJsonRequestProcessorThread;
import org.sonatype.nexus.extdirect.internal.ExtDirectServlet;

public abstract class ExtDirectServletModule
extends ServletModule {
    private static final Logger log = LoggerFactory.getLogger(ExtDirectServletModule.class);
    private final String mountPoint;

    protected ExtDirectServletModule(String mountPoint) {
        this.mountPoint = mountPoint;
    }

    protected void configureServlets() {
        HashMap config = Maps.newHashMap();
        config.put("providersUrl", this.mountPoint.substring(1));
        config.put("minify", Boolean.FALSE.toString());
        config.put("debug", Boolean.toString(log.isDebugEnabled()));
        config.put("jsonRequestProcessorThreadClass", ExtDirectJsonRequestProcessorThread.class.getName());
        config.put("gsonBuilderConfiguratorClass", ExtDirectGsonBuilderConfigurator.class.getName());
        this.serve(String.valueOf(this.mountPoint) + "*", new String[0]).with(ExtDirectServlet.class, (Map)config);
        this.bindSecurityFilter();
    }

    protected abstract void bindSecurityFilter();
}

