/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extdirect.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Key;
import com.softwarementors.extjs.djn.api.Registry;
import com.softwarementors.extjs.djn.config.ApiConfiguration;
import com.softwarementors.extjs.djn.config.GlobalConfiguration;
import com.softwarementors.extjs.djn.router.RequestRouter;
import com.softwarementors.extjs.djn.router.RequestType;
import com.softwarementors.extjs.djn.router.dispatcher.Dispatcher;
import com.softwarementors.extjs.djn.router.processor.poll.PollRequestProcessor;
import com.softwarementors.extjs.djn.servlet.DirectJNgineServlet;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.BeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.extdirect.DirectComponent;
import org.sonatype.nexus.extdirect.internal.ExtDirectDispatcher;
import org.sonatype.nexus.servlet.XFrameOptions;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class ExtDirectServlet
extends DirectJNgineServlet
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(ExtDirectServlet.class);
    private final ApplicationDirectories directories;
    private final BeanLocator beanLocator;
    private final ExtDirectDispatcher extDirectDispatcher;
    private final XFrameOptions xFrameOptions;

    @Inject
    public ExtDirectServlet(ApplicationDirectories directories, BeanLocator beanLocator, ExtDirectDispatcher extDirectDispatcher, XFrameOptions xFrameOptions, @Named(value="${nexus.security.anticsrftoken.enabled:-true}") @Named(value="${nexus.security.anticsrftoken.enabled:-true}") boolean antiCsrfTokenEnabled) {
        super(antiCsrfTokenEnabled, "NX-ANTI-CSRF-TOKEN", -1L);
        this.directories = (ApplicationDirectories)Preconditions.checkNotNull((Object)directories);
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
        this.extDirectDispatcher = (ExtDirectDispatcher)((Object)Preconditions.checkNotNull((Object)((Object)extDirectDispatcher)));
        this.xFrameOptions = (XFrameOptions)Preconditions.checkNotNull((Object)xFrameOptions);
    }

    public void doPost(final HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(request){
            private BufferedReader reader;

            public BufferedReader getReader() throws IOException {
                if (this.reader == null) {
                    try {
                        this.reader = super.getReader();
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.reader = new RequestBoundReader((Reader)new InputStreamReader((InputStream)this.getInputStream(), "UTF-8"), (ServletRequest)request);
                    }
                }
                return this.reader;
            }
        };
        try {
            super.doPost((HttpServletRequest)wrappedRequest, response);
        }
        catch (com.softwarementors.extjs.djn.router.processor.standard.form.upload.FileUploadException fileUploadException) {
            try {
                FileItemIterator fileItems = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()).getItemIterator(request);
                String tid = this.getTransactionId(fileItems);
                response.setContentType("text/html");
                response.setHeader("X-Frame-Options", this.xFrameOptions.getValueForPath(request.getPathInfo()));
                response.getWriter().append("<html><body><textarea>{\"tid\":" + tid + ",\"action\":\"coreui_Upload\",\"method\":\"doUpload\",\"result\":{\"success\": false,\"message\":\"" + StringEscapeUtils.escapeHtml((String)fileUploadException.getMessage()) + "\"},\"type\":\"rpc\"}</textarea></body></html>").flush();
            }
            catch (Exception e) {
                log.warn("Unable to read the ext direct transaction id for upload", (Throwable)e);
                throw fileUploadException;
            }
        }
        if (StringUtils.isBlank((String)response.getHeader("X-Frame-Options")) && !RequestType.FORM_UPLOAD_POST.equals((Object)ExtDirectServlet.getFromRequestContentType((HttpServletRequest)request))) {
            response.setHeader("X-Frame-Options", "DENY");
        }
    }

    private String getTransactionId(FileItemIterator fileItems) throws FileUploadException, IOException {
        String tid = null;
        while (tid == null && fileItems.hasNext()) {
            FileItemStream fileItemStream = fileItems.next();
            if (!StringUtils.equals((String)fileItemStream.getFieldName(), (String)"extTID")) continue;
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)fileItemStream.openStream(), (Writer)writer, (Charset)StandardCharsets.UTF_8);
            tid = writer.toString();
        }
        return tid;
    }

    public void start() throws Exception {
        if (this.getServletConfig() != null) {
            this.createDirectJNgineRouter(this.getServletConfig());
        }
    }

    public void stop() {
    }

    protected List<ApiConfiguration> createApiConfigurationsFromServletConfigurationApi(ServletConfig configuration) {
        Iterable entries = this.beanLocator.locate(Key.get(DirectComponent.class));
        ArrayList apiClasses = Lists.newArrayList((Iterable)Iterables.transform((Iterable)entries, (Function)new Function<BeanEntry<Annotation, DirectComponent>, Class<?>>(){

            @Nullable
            public Class<?> apply(BeanEntry<Annotation, DirectComponent> input) {
                Class implementationClass = input.getImplementationClass();
                log.debug("Registering Ext.Direct component '{}'", (Object)implementationClass);
                return implementationClass;
            }
        }));
        File apiFile = new File(this.directories.getTemporaryDirectory(), "nexus-extdirect/api.js");
        return Lists.newArrayList((Object[])new ApiConfiguration[]{new ApiConfiguration("nexus", apiFile.getName(), apiFile.getAbsolutePath(), "NX.direct.api", "NX.direct", (List)apiClasses)});
    }

    protected Dispatcher createDispatcher(Class<? extends Dispatcher> cls) {
        return this.extDirectDispatcher;
    }

    protected RequestRouter createRequestRouter(final Registry registry, final GlobalConfiguration globalConfiguration) {
        final Dispatcher dispatcher = this.createDispatcher(globalConfiguration.getDispatcherClass());
        return new RequestRouter(registry, globalConfiguration, dispatcher){

            public void processPollRequest(final Reader reader, Writer writer, String pathInfo) throws IOException {
                new PollRequestProcessor(registry, dispatcher, globalConfiguration){

                    protected Object[] getParameters() {
                        if (reader instanceof RequestBoundReader) {
                            ServletRequest request = ((RequestBoundReader)reader).getRequest();
                            Map parameterMap = request.getParameterMap();
                            Map parameters = Maps.newHashMap();
                            if (parameterMap != null) {
                                parameters = Maps.transformEntries((Map)parameterMap, (Maps.EntryTransformer)new Maps.EntryTransformer<String, String[], String>(){

                                    public String transformEntry(@Nullable String key, @Nullable String[] values) {
                                        return values == null || values.length == 0 ? null : values[0];
                                    }
                                });
                            }
                            return new Object[]{parameters};
                        }
                        return super.getParameters();
                    }
                }.process(reader, writer, pathInfo);
            }
        };
    }

    private static class RequestBoundReader
    extends BufferedReader {
        private final ServletRequest request;

        public RequestBoundReader(Reader in, ServletRequest request) {
            super(in);
            this.request = request;
        }

        private ServletRequest getRequest() {
            return this.request;
        }
    }
}

