/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extdirect.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.servlet.ServletScopes;
import com.softwarementors.extjs.djn.servlet.ssm.SsmJsonRequestProcessorThread;
import java.util.concurrent.Callable;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.SubjectThreadState;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.security.UserIdMdcHelper;

public class ExtDirectJsonRequestProcessorThread
extends SsmJsonRequestProcessorThread {
    private final SubjectThreadState threadState;
    private final Callable<String> processRequest;

    public ExtDirectJsonRequestProcessorThread() {
        Subject subject = SecurityUtils.getSubject();
        Preconditions.checkState((subject != null ? 1 : 0) != 0, (Object)"Subject is not set");
        this.threadState = new SubjectThreadState(subject);
        final String baseUrl = BaseUrlHolder.get();
        final String relativePath = BaseUrlHolder.getRelativePath();
        this.processRequest = ServletScopes.transferRequest((Callable)new Callable<String>(){

            @Override
            public String call() {
                ExtDirectJsonRequestProcessorThread.this.threadState.bind();
                UserIdMdcHelper.set();
                try {
                    BaseUrlHolder.set((String)baseUrl, (String)relativePath);
                    String string = ExtDirectJsonRequestProcessorThread.super.processRequest();
                    return string;
                }
                finally {
                    UserIdMdcHelper.unset();
                    ExtDirectJsonRequestProcessorThread.this.threadState.restore();
                }
            }
        });
    }

    public String processRequest() {
        try {
            return this.processRequest.call();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

