/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extdirect.internal;

import com.softwarementors.extjs.djn.api.RegisteredMethod;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.ConstraintViolationException;
import org.apache.commons.collections.ListUtils;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authz.UnauthenticatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.app.FrozenException;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.extdirect.model.Response;
import org.sonatype.nexus.extdirect.model.Responses;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class ExtDirectExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ExtDirectExceptionHandler.class);
    private static final List<Class<Throwable>> SUPPRESSED_EXCEPTIONS = ListUtils.unmodifiableList(Arrays.asList(UnauthenticatedException.class, AuthenticationException.class, ValidationErrorsException.class));

    public Response handleException(RegisteredMethod method, Throwable e) {
        ConstraintViolationException cause;
        Set violations;
        log.debug("Failed to invoke action method: {}, java-method: {}, exception message: {}", new Object[]{method.getFullName(), method.getFullJavaMethodName(), e.getMessage(), this.isSuppressedException(e) ? null : e});
        if (e instanceof ConstraintViolationException && (violations = (cause = (ConstraintViolationException)e).getConstraintViolations()) != null && !violations.isEmpty()) {
            return Responses.invalid(cause);
        }
        if (e instanceof FrozenException || e.getCause() instanceof FrozenException) {
            return Responses.error(new Exception("Nexus Repository Manager is in read-only mode"));
        }
        if (!this.isSuppressedException(e)) {
            log.error("Failed to invoke action method: {}, java-method: {}", new Object[]{method.getFullName(), method.getFullJavaMethodName(), e});
        }
        String exceptionName = e.getClass().getName();
        if (e instanceof SQLException || exceptionName.contains("org.apache.ibatis") || exceptionName.contains("org.sonatype.nexus.datastore") || exceptionName.contains("com.orientechnologies")) {
            return Responses.error(new Exception("A database error occurred"));
        }
        if (e instanceof HttpHostConnectException || exceptionName.contains("com.sonatype.insight.rm.rest.HttpException")) {
            return Responses.error(new Exception("Connection unsuccessful."));
        }
        return Responses.error(e);
    }

    private boolean isSuppressedException(Throwable e) {
        return SUPPRESSED_EXCEPTIONS.stream().anyMatch(ex -> ex.isInstance(e) || ex.isInstance(e.getCause()));
    }
}

