/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.conda.orient.internal;

import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.repository.conda.orient.CondaFacet;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;

@Named
public class CondaFacetImpl
extends FacetSupport
implements CondaFacet {
    public static final List<HashAlgorithm> HASH_ALGORITHMS = ImmutableList.of((Object)HashAlgorithm.SHA1);

    @Override
    @Nullable
    public Component findComponent(StorageTx tx, Repository repository, String arch, String name, String version) {
        Iterable components = tx.findComponents(Query.builder().where("name").eq((Object)name).and("group").eq((Object)arch).and("version").eq((Object)version).build(), Collections.singletonList(repository));
        if (components.iterator().hasNext()) {
            return (Component)components.iterator().next();
        }
        return null;
    }

    @Override
    @Nullable
    public Asset findAsset(StorageTx tx, Bucket bucket, String assetName) {
        return tx.findAssetWithProperty("name", (Object)assetName, bucket);
    }

    @Override
    public Content saveAsset(StorageTx tx, Asset asset, InputStreamSupplier contentSupplier, Payload payload) throws IOException {
        AttributesMap contentAttributes = null;
        String contentType = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
            contentType = payload.getContentType();
        }
        return this.saveAsset(tx, asset, contentSupplier, contentType, contentAttributes);
    }

    @Override
    public Content saveAsset(StorageTx tx, Asset asset, InputStreamSupplier contentSupplier, String contentType, @Nullable AttributesMap contentAttributes) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, asset.name(), contentSupplier, HASH_ALGORITHMS, null, contentType, false);
        tx.saveAsset(asset);
        return this.toContent(asset, assetBlob.getBlob());
    }

    @Override
    public Content toContent(Asset asset, Blob blob) {
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }
}

