/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.conda.datastore.internal.proxy;

import com.sonatype.nexus.repository.conda.AssetKind;
import com.sonatype.nexus.repository.conda.datastore.CondaContentFacet;
import com.sonatype.nexus.repository.conda.util.CondaPathUtils;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.content.facet.ContentProxyFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
@Facet.Exposed
public class CondaProxyFacet
extends ContentProxyFacetSupport {
    @Nullable
    protected Content getCachedContent(Context context) {
        AssetKind assetKind = this.getAssetKind(context);
        TokenMatcher.State matcherState = CondaPathUtils.matcherState(context);
        String assetPath = CondaPathUtils.buildAssetPath(assetKind, matcherState);
        return ((CondaContentFacet)this.facet(CondaContentFacet.class)).getAsset(assetPath).map(FluentAsset::download).orElse(null);
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = this.getAssetKind(context);
        TokenMatcher.State matcherState = CondaPathUtils.matcherState(context);
        if (assetKind == AssetKind.ARCH_TAR_PACKAGE || assetKind == AssetKind.ARCH_CONDA_PACKAGE) {
            return this.putCondaPackage(content, assetKind, matcherState);
        }
        String assetPath = CondaPathUtils.buildAssetPath(assetKind, matcherState);
        return this.putMetadata(content, assetKind, assetPath);
    }

    protected String getUrl(@Nonnull Context context) {
        return context.getRequest().getPath().substring(1);
    }

    private Content putMetadata(Content content, AssetKind assetKind, String assetPath) {
        return ((CondaContentFacet)this.facet(CondaContentFacet.class)).findOrCreateAsset((Payload)content, assetKind, assetPath).markAsCached((Payload)content).download();
    }

    private Content putCondaPackage(Content content, AssetKind assetKind, TokenMatcher.State matcherState) {
        String assetPath = CondaPathUtils.buildCondaPackagePath(matcherState);
        String name = CondaPathUtils.name(matcherState);
        String namespace = CondaPathUtils.arch(matcherState);
        String version = CondaPathUtils.version(matcherState);
        return ((CondaContentFacet)this.facet(CondaContentFacet.class)).findOrCreateAssetWithComponent((Payload)content, assetPath, name, namespace, version, assetKind).markAsCached((Payload)content).download();
    }

    private AssetKind getAssetKind(Context context) {
        return (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
    }
}

