/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.conda.datastore.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.conda.AssetKind;
import com.sonatype.nexus.repository.conda.datastore.CondaContentFacet;
import com.sonatype.nexus.repository.conda.util.CondaPathUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="conda")
public class CondaContentFacetImpl
extends ContentFacetSupport
implements CondaContentFacet {
    private static final List<HashAlgorithm> HASH_ALGORITHMS = Collections.singletonList(HashAlgorithm.SHA1);

    @Inject
    public CondaContentFacetImpl(@Named(value="conda") @Named(value="conda") FormatStoreManager formatStoreManager) {
        super(formatStoreManager);
    }

    @Override
    public Optional<FluentAsset> getAsset(String assetPath) {
        Preconditions.checkNotNull((Object)assetPath);
        return this.assets().path(CondaPathUtils.normalizeAssetPath(assetPath)).find();
    }

    @Override
    public FluentAsset findOrCreateAsset(Payload payload, AssetKind assetKind, String assetPath) {
        Preconditions.checkNotNull((Object)payload);
        Preconditions.checkNotNull((Object)((Object)assetKind));
        Preconditions.checkNotNull((Object)assetPath);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, HASH_ALGORITHMS);){
            return this.assets().path(CondaPathUtils.normalizeAssetPath(assetPath)).kind(assetKind.name()).blob(tempBlob).save();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public FluentAsset findOrCreateAssetWithComponent(Payload payload, String assetPath, String name, String namespace, String version, AssetKind assetKind) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)namespace);
        Preconditions.checkNotNull((Object)version);
        FluentComponent component = this.findOrCreateComponent(name, namespace, version);
        Throwable throwable = null;
        Object var9_10 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, HASH_ALGORITHMS);){
            return component.asset(CondaPathUtils.normalizeAssetPath(assetPath)).kind(assetKind.name()).blob(tempBlob).save();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private FluentComponent findOrCreateComponent(String name, String namespace, String version) {
        return this.components().name(name).namespace(namespace).version(version).normalizedVersion(this.versionNormalizerService().getNormalizedVersionByFormat(version, this.repository().getFormat())).getOrCreate();
    }
}

