/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.orient.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.codec.digest.DigestUtils;
import org.sonatype.nexus.common.upgrade.Dependencies;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;

@Named
@Singleton
@Upgrades(model="rubygems", from="1.4", to="1.5")
@Dependencies(value={@DependsOn(model="config", version="1.10", checkpoint=true), @DependsOn(model="component", version="1.16", checkpoint=true)})
public class RubygemsUpgrade_1_5
extends DatabaseUpgradeSupport {
    private static final String SELECT_RUBY_REPOSITORIES = "SELECT FROM repository WHERE recipe_name = 'rubygems-hosted'";
    private static final String UPDATE_RUBY_ASSETS = "UPDATE asset SET attributes.rubygems.dirty_as_of = :dirtyAsOf, attributes.checksum.sha1 = :dirtySha1 WHERE bucket.repository_name = :repositoryName AND name like :namePattern";
    private static final String P_REPOSITORY_NAME = "repository_name";
    private static final String ASSET_NAME_PATTERN = "info/%";
    private final Provider<DatabaseInstance> configDatabaseInstance;
    private final Provider<DatabaseInstance> componentInstanceProvider;

    @Inject
    public RubygemsUpgrade_1_5(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> configDatabaseInstance, @Named(value="component") @Named(value="component") Provider<DatabaseInstance> componentInstanceProvider) {
        this.configDatabaseInstance = (Provider)Preconditions.checkNotNull(configDatabaseInstance);
        this.componentInstanceProvider = (Provider)Preconditions.checkNotNull(componentInstanceProvider);
    }

    public void apply() throws Exception {
        List rubyRepositories;
        Throwable throwable = null;
        Object var3_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            rubyRepositories = db.query((OQuery)new OSQLSynchQuery(SELECT_RUBY_REPOSITORIES), new Object[0]).stream().map(d -> (String)d.field(P_REPOSITORY_NAME)).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        for (String repository : rubyRepositories) {
            this.markInfoFilesAsDirty(repository, ASSET_NAME_PATTERN, offsetDateTime);
        }
    }

    private void markInfoFilesAsDirty(String repository, String namePattern, OffsetDateTime dateTime) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (ODatabaseDocumentTx tx = ((DatabaseInstance)this.componentInstanceProvider.get()).connect();){
            HashMap<String, String> sqlParams = new HashMap<String, String>();
            sqlParams.put("repositoryName", repository);
            sqlParams.put("namePattern", namePattern);
            sqlParams.put("dirtyAsOf", dateTime.toString());
            sqlParams.put("dirtySha1", DigestUtils.sha1Hex((byte[])dateTime.toString().getBytes(StandardCharsets.UTF_8)));
            tx.command((OCommandRequest)new OCommandSQL(UPDATE_RUBY_ASSETS)).execute(new Object[]{sqlParams});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

