/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.orient.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.UpgradeTaskScheduler;

@Named
@Singleton
@Upgrades(model="rubygems", from="1.2", to="1.3")
@DependsOn(model="config", version="1.6", checkpoint=true)
public class RubygemsHashAndAttributesUpgrade_1_3
extends DatabaseUpgradeSupport {
    private static final String SELECT_RUBY_REPOSITORIES = "select from repository where recipe_name in ['rubygems-hosted', 'rubygems-proxy']";
    private static final String P_REPOSITORY_NAME = "repository_name";
    private final Provider<DatabaseInstance> configDatabaseInstance;
    private final UpgradeTaskScheduler scheduler;
    private final TaskScheduler taskScheduler;

    @Inject
    public RubygemsHashAndAttributesUpgrade_1_3(UpgradeTaskScheduler scheduler, TaskScheduler taskScheduler, @Named(value="config") @Named(value="config") Provider<DatabaseInstance> configDatabaseInstance) {
        this.configDatabaseInstance = (Provider)Preconditions.checkNotNull(configDatabaseInstance);
        this.scheduler = (UpgradeTaskScheduler)Preconditions.checkNotNull((Object)scheduler);
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    public void apply() throws Exception {
        String rubyRepositoryNames;
        Throwable throwable = null;
        Object var3_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            rubyRepositoryNames = db.query((OQuery)new OSQLSynchQuery(SELECT_RUBY_REPOSITORIES), new Object[0]).stream().map(d -> (String)d.field(P_REPOSITORY_NAME)).collect(Collectors.joining(","));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.log.debug("Found the following ruby repositories: {}", (Object)rubyRepositoryNames);
        if (Strings2.isBlank((String)rubyRepositoryNames)) {
            return;
        }
        this.scheduleAttributeUpdate(rubyRepositoryNames);
        this.scheduleSha256(rubyRepositoryNames);
    }

    private void scheduleAttributeUpdate(String repositoryName) {
        TaskConfiguration conf = this.createConfiguration("repository.ruby.rebuild.attributes", repositoryName);
        conf.setName("Updating gem attributes for " + repositoryName);
        this.scheduler.schedule(this.createConfiguration("repository.ruby.rebuild.attributes", repositoryName));
    }

    private void scheduleSha256(String repositoryName) {
        TaskConfiguration conf = this.createConfiguration("repository.rubygems.generate-sha256-checksums", repositoryName);
        conf.setName("Generating sha256 checksums for " + repositoryName);
        this.scheduler.schedule(conf);
    }

    private TaskConfiguration createConfiguration(String typeId, String repositoryName) {
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance(typeId);
        configuration.setString("repositoryName", repositoryName);
        return configuration;
    }
}

