/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.orient.internal.hosted;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Named;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.internal.hosted.GemInfoHostedFacet;
import org.sonatype.nexus.repository.rubygems.internal.hosted.VersionsHostedFacet;
import org.sonatype.nexus.repository.rubygems.internal.hosted.VersionsHostedFacetSupport;
import org.sonatype.nexus.repository.rubygems.orient.OrientRubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.orient.internal.hosted.OrientRubygemsMetadataFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEvent;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentDeletedEvent;
import org.sonatype.nexus.repository.storage.ComponentEvent;
import org.sonatype.nexus.repository.storage.MetadataNode;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientVersionsHostedFacet
extends VersionsHostedFacetSupport
implements VersionsHostedFacet,
EventAware.Asynchronous {
    private static final String PREFIX = "---\n";

    @Override
    @Guarded(by={"STARTED"})
    public Optional<Content> get() throws IOException {
        Content existing = this.content().get(OrientVersionsHostedFacet.file());
        if (existing != null) {
            return Optional.of(existing);
        }
        return Optional.of(this.internalRebuild());
    }

    @Override
    @Guarded(by={"STARTED"})
    public Content rebuild() throws IOException {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            Content content = this.internalRebuild();
            return content;
        }
        finally {
            UnitOfWork.end();
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public Content rebuild(boolean force) throws IOException {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            Content existing;
            if (!force && (existing = this.content().get(OrientVersionsHostedFacet.file())) != null && !this.metadata().isStale(existing)) {
                this.log.debug("Skipping rebuild as the file is up to date in {}", (Object)this.getRepository().getName());
                Content content = existing;
                return content;
            }
            Content content = this.internalRebuild();
            return content;
        }
        finally {
            UnitOfWork.end();
        }
    }

    private Content internalRebuild() throws IOException {
        this.log.debug("Starting rebuild for {}", (Object)this.getRepository().getName());
        return (Content)this.cooperation.on(this::doRebuild).checkFunction(() -> Optional.ofNullable(this.content().get(OrientVersionsHostedFacet.file()))).cooperate("versions", new String[0]);
    }

    private Content doRebuild() throws IOException {
        this.log.debug("Starting rebuild for {}", (Object)this.getRepository().getName());
        OffsetDateTime start = OffsetDateTime.now();
        StringBuilder sb = new StringBuilder();
        sb.append("created_at: ").append(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(start)).append('\n');
        sb.append(PREFIX);
        this.getVersionsByGemName().forEach((gemName, versions) -> this.append(sb, (String)gemName, (Collection<String>)versions, this.checksum((String)gemName)));
        Content content = this.content().putRubygemsFile(OrientVersionsHostedFacet.file(), (Payload)new StringPayload(sb.toString(), "text/plain"));
        this.metadata().markAsRebuilt((Asset)content.getAttributes().require(Asset.class), start);
        return content;
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetEvent event) throws IOException {
        if (!event.isLocal()) {
            this.log.debug("Skipping non-local event {}", (Object)event);
            return;
        }
        if (this.metadata().isRelevant(event) && event.getComponentId() != null) {
            this.log.debug("Processing event {}", (Object)event);
            this.markDirty();
            this.maybeScheduleRebuild();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(ComponentDeletedEvent event) throws IOException {
        if (!event.isLocal()) {
            this.log.debug("Skipping non-local event {}", (Object)event);
            return;
        }
        if (this.metadata().isRelevant((ComponentEvent)event) && event.getComponentId() != null) {
            this.log.debug("Processing event {}", (Object)event);
            this.markDirty();
            this.maybeScheduleRebuild();
        }
    }

    private void markDirty() throws IOException {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            Optional.ofNullable(this.content().get(OrientVersionsHostedFacet.file())).map(content -> (Asset)content.getAttributes().require(Asset.class)).ifPresent(this.metadata()::markDirty);
        }
        finally {
            UnitOfWork.end();
        }
    }

    private void append(StringBuilder sb, String gemName, Collection<String> versions, String checksum) {
        CancelableHelper.checkCancellation();
        if (versions.size() == 0) {
            this.log.debug("Skipping {} as no versions were found", (Object)gemName);
            return;
        }
        sb.append(gemName).append(' ');
        for (String version : versions) {
            sb.append(version).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(' ');
        if (checksum != null) {
            sb.append(checksum);
        } else {
            sb.append("unknown");
        }
        sb.append('\n');
    }

    private static RubygemsFile file() {
        return RubygemsFile.create("versions", new String[0]);
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean needsRebuild() {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            Content existing = this.content().get(OrientVersionsHostedFacet.file());
            boolean needsRebuild = existing == null || this.metadata().isStale(existing);
            this.log.debug("Needs rebuild {} for {} ", (Object)needsRebuild, (Object)this.getRepository().getName());
            boolean bl = needsRebuild;
            return bl;
        }
        catch (IOException e) {
            this.log.debug("An error occurred checking whether a rebuild is required, assuming needed", (Throwable)e);
            return true;
        }
        finally {
            UnitOfWork.end();
        }
    }

    private String checksum(String gemName) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (StorageTx storageTx = (StorageTx)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier().get();){
                return ((GemInfoHostedFacet)this.getRepository().facet(GemInfoHostedFacet.class)).get(gemName).map(Content::getAttributes).map(attr -> (Map)attr.get("hashCodesMap", Content.T_CONTENT_HASH_CODES_MAP)).map(checksums -> (HashCode)checksums.get(HashAlgorithm.MD5)).map(HashCode::toString).orElse(null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.warn("An error occurred while retrieving the checksum for {} in {}", new Object[]{gemName, this.getRepository().getName(), this.log.isDebugEnabled() ? e : null});
            return null;
        }
    }

    private Map<String, Set<String>> getVersionsByGemName() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (StorageTx storageTx = (StorageTx)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier().get();){
            storageTx.begin();
            Bucket bucket = storageTx.findBucket(this.getRepository());
            return StreamSupport.stream(storageTx.browseComponents(bucket).spliterator(), false).collect(Collectors.groupingBy(MetadataNode::name, Collectors.mapping(Component::version, Collectors.toSet())));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private OrientRubygemsMetadataFacet metadata() {
        return (OrientRubygemsMetadataFacet)this.getRepository().facet(OrientRubygemsMetadataFacet.class);
    }

    private OrientRubygemsContentFacet content() {
        return (OrientRubygemsContentFacet)this.getRepository().facet(OrientRubygemsContentFacet.class);
    }
}

