/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.orient.internal.hosted;

import java.time.OffsetDateTime;
import java.util.Optional;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEvent;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentEvent;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.transaction.UnitOfWork;

@Facet.Exposed
public class OrientRubygemsMetadataFacet
extends FacetSupport {
    private static final String DIRTY_TIME_KEY = "dirty_as_of";
    private static final String BUILT_TIME_KEY = "built_at";

    @Guarded(by={"STARTED"})
    public void markAsRebuilt(Asset asset, OffsetDateTime start) {
        this.log.debug("Marking as rebuilt {}", (Object)asset);
        asset.formatAttributes().set(BUILT_TIME_KEY, (Object)start.toString());
        this.saveAsset(asset);
    }

    @Guarded(by={"STARTED"})
    public void markDirty(Asset asset) {
        this.log.debug("Marking dirty {}", (Object)asset);
        asset.formatAttributes().set(DIRTY_TIME_KEY, (Object)OffsetDateTime.now().toString());
        this.saveAsset(asset);
    }

    @Guarded(by={"STARTED"})
    @TransactionalStoreMetadata
    public void saveAsset(Asset asset) {
        StorageTx storageTx = (StorageTx)UnitOfWork.currentTx();
        storageTx.saveAsset(asset);
    }

    @Guarded(by={"STARTED"})
    public boolean isStale(Content content) {
        Asset asset = (Asset)content.getAttributes().require(Asset.class);
        Optional<OffsetDateTime> rebuilt = Optional.ofNullable((String)asset.formatAttributes().get(BUILT_TIME_KEY, String.class)).map(OffsetDateTime::parse);
        if (!rebuilt.isPresent()) {
            return false;
        }
        Optional<OffsetDateTime> dirty = Optional.ofNullable((String)asset.formatAttributes().get(DIRTY_TIME_KEY, String.class)).map(OffsetDateTime::parse);
        if (!dirty.isPresent()) {
            return false;
        }
        return dirty.get().isAfter(rebuilt.get());
    }

    @Guarded(by={"STARTED"})
    public boolean isRelevant(AssetEvent event) {
        return this.getRepository().getName().equals(event.getRepositoryName());
    }

    @Guarded(by={"STARTED"})
    public boolean isRelevant(ComponentEvent event) {
        return this.getRepository().getName().equals(event.getRepositoryName());
    }

    public Component getComponent(EntityId componentId) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (StorageTx storageTx = (StorageTx)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier().get();){
            storageTx.begin();
            return storageTx.findComponent(componentId);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

