/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.orient.internal.hosted;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.internal.hosted.UpdateRubygemsAttributesTask;
import org.sonatype.nexus.repository.rubygems.internal.utils.GemSpecificationUtils;
import org.sonatype.nexus.repository.rubygems.orient.internal.OrientGemsUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.types.GroupType;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@TaskLogging(value=TaskLogType.TASK_LOG_ONLY_WITH_PROGRESS)
public class OrientRubygemsAttributesTask
extends RepositoryTaskSupport
implements UpdateRubygemsAttributesTask {
    private static final String BEGINNING_ID = "#-1:-1";
    private static final String ASSETS_WHERE = "@rid > :rid";
    private static final String ASSETS_SUFFIX = "ORDER BY @rid LIMIT :limit";
    private static final int BATCH_SIZE = 100;
    private final AssetEntityAdapter assetEntityAdapter;
    private final Stopwatch sw = Stopwatch.createUnstarted();
    private ProgressLogIntervalHelper progressLogger;
    private int processed = 0;
    private int failed = 0;
    private int skipped = 0;

    @Inject
    public OrientRubygemsAttributesTask(AssetEntityAdapter assetEntityAdapter) {
        this.assetEntityAdapter = (AssetEntityAdapter)Preconditions.checkNotNull((Object)assetEntityAdapter);
    }

    public String getMessage() {
        return "Rebuilding attributes for RubyGems";
    }

    protected void execute(Repository repository) {
        this.log.info("Processing repository {}", (Object)repository.getName());
        this.processed = 0;
        this.failed = 0;
        this.skipped = 0;
        this.progressLogger = new ProgressLogIntervalHelper(this.log, 60);
        this.sw.start();
        try {
            String lastId = BEGINNING_ID;
            while (lastId != null) {
                try {
                    lastId = this.processBatch(repository, lastId);
                }
                catch (Exception e) {
                    Throwables.propagateIfPossible((Throwable)e, RuntimeException.class);
                    throw new RuntimeException(e);
                }
            }
            this.progressLogger.flush();
        }
        finally {
            this.progressLogger.close();
            this.sw.reset();
        }
    }

    @Nullable
    private String processBatch(Repository repository, String lastId) throws Exception {
        this.log.debug("Processing next batch of rubygems assets for update. Starting at id = {} with max batch size = {}", (Object)lastId, (Object)100);
        return (String)TransactionalStoreMetadata.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).throwing(Exception.class).call(() -> {
            Iterable<Asset> assets = this.readAssets(repository, lastId);
            return this.updateAssets(repository, assets);
        });
    }

    private String updateAssets(Repository repository, Iterable<Asset> assets) {
        String lastId = null;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        for (Asset asset : assets) {
            CancelableHelper.checkCancellation();
            try {
                lastId = this.assetEntityAdapter.recordIdentity((Entity)asset).toString();
                String kind = (String)asset.formatAttributes().get("asset_kind", String.class);
                if (!AssetKind.GEM.name().equals(kind)) {
                    this.log.debug("Skipping non-gem {}", (Object)asset.name());
                    ++this.skipped;
                    continue;
                }
                InputStreamSupplier supplier = this.supplier(tx, asset);
                if (supplier == null) continue;
                this.log.debug("Processing {}", (Object)asset.name());
                OrientGemsUtils.applyGemspecAttributesToGem(asset, GemSpecificationUtils.retrieveGemSpecification(supplier));
                tx.saveAsset(asset);
                ++this.processed;
                this.progressLogger.info("Processed {} skipped {} failed {} elapsed {}", new Object[]{this.processed, this.skipped, this.failed, this.sw});
            }
            catch (Exception e) {
                this.log.warn("Failed to process path {} error: {}", new Object[]{asset.name(), e.getMessage(), this.log.isDebugEnabled() ? e : null});
                ++this.failed;
            }
        }
        return lastId;
    }

    private Iterable<Asset> readAssets(Repository repository, String lastId) {
        StorageTx storageTx = (StorageTx)UnitOfWork.currentTx();
        ImmutableMap parameters = ImmutableMap.of((Object)"rid", (Object)lastId, (Object)"limit", (Object)100);
        return storageTx.findAssets(ASSETS_WHERE, (Map)parameters, Collections.singletonList(repository), ASSETS_SUFFIX);
    }

    private InputStreamSupplier supplier(StorageTx tx, Asset asset) {
        Blob blob = Optional.ofNullable(asset.blobRef()).map(arg_0 -> ((StorageTx)tx).getBlob(arg_0)).orElse(null);
        if (blob == null) {
            this.log.debug("Missing blob for {}", (Object)asset.name());
            ++this.skipped;
            return null;
        }
        return () -> ((Blob)blob).getInputStream();
    }

    protected boolean appliesTo(Repository repository) {
        return "rubygems".equals(repository.getFormat().getValue()) && !(repository.getType() instanceof GroupType);
    }
}

