/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.orient.internal.hosted;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.internal.hosted.GemInfoHostedFacet;
import org.sonatype.nexus.repository.rubygems.orient.OrientRubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.orient.internal.hosted.OrientRubygemsMetadataFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEvent;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentDeletedEvent;
import org.sonatype.nexus.repository.storage.ComponentEvent;
import org.sonatype.nexus.repository.storage.MetadataNode;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientGemInfoHostedFacet
extends FacetSupport
implements GemInfoHostedFacet,
EventAware.Asynchronous {
    protected static final String PREFIX = "---\n";
    private final Cooperation2Factory.Builder cooperationBuilder;
    private Cooperation2 cooperation;

    @Inject
    public OrientGemInfoHostedFacet(Cooperation2Factory cooperationFactory, @Named(value="${nexus.ruby.geminfo.cooperation.enabled:-true}") @Named(value="${nexus.ruby.geminfo.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.ruby.geminfo.cooperation.majorTimeout:-0s}") @Named(value="${nexus.ruby.geminfo.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.ruby.geminfo.cooperation.minorTimeout:-30s}") @Named(value="${nexus.ruby.geminfo.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.ruby.geminfo.cooperation.threadsPerKey:-100}") @Named(value="${nexus.ruby.geminfo.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        this.cooperationBuilder = ((Cooperation2Factory)Preconditions.checkNotNull((Object)cooperationFactory)).configure().enabled(cooperationEnabled).majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.cooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":geminfo");
    }

    @Override
    @Guarded(by={"STARTED"})
    public Optional<Content> get(String gemName) throws IOException {
        Content existing = this.content().get(OrientGemInfoHostedFacet.file(gemName));
        if (existing != null && !this.metadata().isStale(existing)) {
            return Optional.of(existing);
        }
        return Optional.ofNullable(this.rebuild(gemName));
    }

    @Override
    @Nullable
    @Guarded(by={"STARTED"})
    public Content rebuild(String gemName) throws IOException {
        return (Content)this.cooperation.on(() -> this.doRebuild(gemName)).checkFunction(() -> Optional.ofNullable(this.content().get(OrientGemInfoHostedFacet.file(gemName)))).cooperate(gemName, new String[0]);
    }

    private Content doRebuild(String gemName) throws IOException {
        OffsetDateTime started = OffsetDateTime.now();
        String versions = this.content().getGemsByName(gemName).map(this::createVersionLine).filter(Objects::nonNull).collect(Collectors.joining("\n", PREFIX, ""));
        if (PREFIX.length() == versions.length()) {
            this.log.debug("Built empty response for {} in {} attempting to remove existing asset", (Object)gemName, (Object)this.getRepository().getName());
            this.content().delete(OrientGemInfoHostedFacet.file(gemName));
            return null;
        }
        Content content = this.content().putRubygemsFile(OrientGemInfoHostedFacet.file(gemName), (Payload)new StringPayload(versions, "text/plain"));
        this.metadata().markAsRebuilt((Asset)content.getAttributes().require(Asset.class), started);
        return content;
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetEvent event) {
        if (this.metadata().isRelevant(event) && event.getComponentId() != null) {
            UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
            try {
                Optional.ofNullable(this.metadata().getComponent(event.getComponentId())).map(MetadataNode::name).flatMap(this::findGemInfo).ifPresent(this.metadata()::markDirty);
            }
            finally {
                UnitOfWork.end();
            }
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(ComponentDeletedEvent event) {
        if (this.metadata().isRelevant((ComponentEvent)event)) {
            Optional.ofNullable(event.getComponent()).map(MetadataNode::name).ifPresent(this::markForRebuild);
        }
    }

    @Override
    public void markForRebuild(String gemName) {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            boolean otherVersionsExist = this.content().getGemsByName(gemName).findAny().isPresent();
            if (otherVersionsExist) {
                this.log.debug("Marking {} in {} for rebuild", (Object)gemName, (Object)this.getRepository().getName());
                this.findGemInfo(gemName).ifPresent(this.metadata()::markDirty);
            } else {
                this.log.debug("Deleting info/{} in {}", (Object)gemName, (Object)this.getRepository().getName());
                this.deleteGemInfo(gemName);
            }
        }
        finally {
            UnitOfWork.end();
        }
    }

    private void deleteGemInfo(String gemName) {
        try {
            this.content().delete(OrientGemInfoHostedFacet.file(gemName));
        }
        catch (IOException e) {
            this.log.error("Unable to delete info/{} in {} cause {}", new Object[]{gemName, this.getRepository().getName(), e.getMessage(), this.log.isDebugEnabled() ? e : null});
        }
    }

    @Nullable
    private String createVersionLine(Asset asset) {
        Component component = this.metadata().getComponent(asset.componentId());
        if (component == null) {
            this.log.warn("Gem {} is missing component in {}", (Object)asset.name(), (Object)this.getRepository().getName());
            return null;
        }
        HashCode checksum = asset.getChecksum(HashAlgorithm.SHA256);
        if (checksum == null) {
            this.log.debug("Missing sha256 or blob for {} in {}", (Object)asset.name(), (Object)this.getRepository().getName());
            return null;
        }
        NestedAttributesMap rubyAttr = asset.attributes().child("rubygems");
        String platform = (String)rubyAttr.get("platform", String.class);
        String dependencies = (String)rubyAttr.get("dependencies", String.class);
        String requiredRubyVersion = (String)rubyAttr.get("required ruby version", String.class);
        String requiredRubygemsVersion = (String)rubyAttr.get("required rubygems version", String.class);
        if (dependencies == null) {
            this.log.warn("Skipping {} as the dependencies information is missing in {}", (Object)asset.name(), (Object)this.getRepository().getName());
            return null;
        }
        try {
            return this.createVersionLine(component.version(), platform, dependencies, checksum.toString(), requiredRubyVersion, requiredRubygemsVersion);
        }
        catch (IllegalArgumentException e) {
            this.log.warn("Could not parse version {} from gem {}", new Object[]{component.version(), asset.name(), this.log.isDebugEnabled() ? e : null});
            return null;
        }
    }

    private static RubygemsFile file(String gemName) {
        return RubygemsFile.create(String.valueOf(RubygemsFile.API_GEM_INFO) + gemName, new String[0]);
    }

    private Optional<Asset> findGemInfo(String gemName) {
        try {
            return Optional.ofNullable(this.content().get(OrientGemInfoHostedFacet.file(gemName))).map(Content::getAttributes).map(attr -> (Asset)attr.require(Asset.class));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private OrientRubygemsContentFacet content() {
        return (OrientRubygemsContentFacet)this.getRepository().facet(OrientRubygemsContentFacet.class);
    }

    private OrientRubygemsMetadataFacet metadata() {
        return (OrientRubygemsMetadataFacet)this.getRepository().facet(OrientRubygemsMetadataFacet.class);
    }
}

