/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.orient.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.HashAlgorithmHelper;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.internal.utils.GemSpecificationUtils;
import org.sonatype.nexus.repository.rubygems.orient.OrientRubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.orient.internal.OrientRubygemsCommonUtils;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.OrientHardLinkHelper;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.PathPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="rubygems")
@Singleton
public class OrientRubygemsUploadHandler
extends UploadHandlerSupport {
    private UploadDefinition definition;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapter variableResolverAdapter;
    private final OrientHardLinkHelper hardLinkHelper;
    private final HashAlgorithmHelper hashAlgorithmHelper;

    @Inject
    public OrientRubygemsUploadHandler(ContentPermissionChecker contentPermissionChecker, @Named(value="simple") @Named(value="simple") VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions, OrientHardLinkHelper hardLinkHelper, HashAlgorithmHelper hashAlgorithmHelper) {
        super(uploadDefinitionExtensions);
        this.contentPermissionChecker = contentPermissionChecker;
        this.variableResolverAdapter = variableResolverAdapter;
        this.hardLinkHelper = (OrientHardLinkHelper)Preconditions.checkNotNull((Object)hardLinkHelper);
        this.hashAlgorithmHelper = (HashAlgorithmHelper)Preconditions.checkNotNull((Object)hashAlgorithmHelper);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        OrientRubygemsContentFacet facet = (OrientRubygemsContentFacet)repository.facet(OrientRubygemsContentFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)((AssetUpload)upload.getAssetUploads().get(0)).getPayload(), OrientRubygemsCommonUtils.HASH_ALGORITHMS);){
            UploadResponse uploadResponse;
            GemCoordinate coordinates = GemSpecificationUtils.retrieveGemSpecification((InputStreamSupplier)tempBlob).getCoordinate();
            this.ensurePermitted(repository.getName(), "rubygems", coordinates.gemPath(), this.coordinatesToMap(coordinates));
            UnitOfWork.begin((Supplier)storageFacet.txSupplier());
            try {
                uploadResponse = new UploadResponse(facet.hardlinkPutGem(coordinates, tempBlob));
            }
            catch (Throwable throwable2) {
                UnitOfWork.end();
                throw throwable2;
            }
            UnitOfWork.end();
            return uploadResponse;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public Content handle(ImportFileConfiguration configuration) throws IOException {
        String filename = configuration.getFile().getName();
        if (!filename.endsWith(RubygemsFile.GEM_SUFFIX)) {
            this.log.trace("Skipping {} as we only care about gem files.", (Object)filename);
            return null;
        }
        if (configuration.isHardLinkingEnabled()) {
            return this.handleHardLink(configuration);
        }
        File content = configuration.getFile();
        Repository repository = configuration.getRepository();
        Path contentPath = content.toPath();
        OrientRubygemsContentFacet facet = (OrientRubygemsContentFacet)repository.facet(OrientRubygemsContentFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Throwable throwable = null;
        Object var10_11 = null;
        try {
            Content content2;
            TempBlob tempBlob;
            PathPayload payload;
            block18: {
                block17: {
                    payload = new PathPayload(contentPath, Files.probeContentType(contentPath));
                    tempBlob = storageFacet.createTempBlob((Payload)payload, OrientRubygemsCommonUtils.HASH_ALGORITHMS);
                    GemCoordinate coordinates = GemSpecificationUtils.retrieveGemSpecification((InputStreamSupplier)tempBlob).getCoordinate();
                    this.ensurePermitted(repository.getName(), "rubygems", coordinates.gemPath(), this.coordinatesToMap(coordinates));
                    Asset asset = facet.hardlinkPutGem(coordinates, tempBlob);
                    content2 = OrientRubygemsCommonUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
                    if (tempBlob == null) break block17;
                    tempBlob.close();
                }
                if (payload == null) break block18;
                payload.close();
            }
            return content2;
            {
                catch (Throwable throwable2) {
                    try {
                        if (tempBlob != null) {
                            tempBlob.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (payload != null) {
                            payload.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private Content handleHardLink(ImportFileConfiguration configuration) throws IOException {
        File content = configuration.getFile();
        Repository repository = configuration.getRepository();
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Map checksums = this.hashAlgorithmHelper.calculateChecksums(content, Arrays.asList(HashAlgorithm.MD5, HashAlgorithm.SHA1));
        AssetBlob assetBlob = this.hardLinkHelper.ingestHardLink(tx, content, checksums);
        GemCoordinate coordinates = GemSpecificationUtils.retrieveGemSpecification(() -> assetBlob.getBlob().getInputStream()).getCoordinate();
        this.ensurePermitted(repository.getName(), "rubygems", coordinates.gemPath(), this.coordinatesToMap(coordinates));
        OrientRubygemsContentFacet facet = (OrientRubygemsContentFacet)repository.facet(OrientRubygemsContentFacet.class);
        Asset asset = facet.hardlinkPutGem(coordinates, assetBlob);
        return OrientRubygemsCommonUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    public Content handle(Repository repository, File content, String path) throws IOException {
        return this.handle(new ImportFileConfiguration(repository, content, path));
    }

    private Map<String, String> coordinatesToMap(GemCoordinate coordinates) {
        return ImmutableMap.of((Object)"name", (Object)coordinates.getName(), (Object)"version", (Object)coordinates.getVersion());
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinition("rubygems", false);
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }

    public boolean supportsExportImport() {
        return true;
    }
}

