/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.orient.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.joda.time.ReadableInstant;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.internal.BundlerGemsPayload;
import org.sonatype.nexus.repository.rubygems.internal.utils.GemSpecificationUtils;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerGem;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerGems;
import org.sonatype.nexus.repository.rubygems.marshal.GemSpecification;
import org.sonatype.nexus.repository.rubygems.marshal.Marshal;
import org.sonatype.nexus.repository.rubygems.orient.OrientRubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.orient.internal.OrientBundlerApiUtils;
import org.sonatype.nexus.repository.rubygems.orient.internal.OrientGemsUtils;
import org.sonatype.nexus.repository.rubygems.orient.internal.OrientRubygemsCommonUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientRubygemsProxyFacet
extends ProxyFacetSupport {
    static final BytesPayload EMPTY_PAYLOAD = new BytesPayload(new byte[0], "application/octet-stream");
    static final BundlerGemsPayload EMPTY_BUNDLER_GEMS_PAYLOAD = new BundlerGemsPayload(BundlerGems.EMPTY);

    @TransactionalTouchBlob
    protected Content getCachedContent(Context context) throws IOException {
        RubygemsFile file = this.getRubygemsFile(context);
        if (AssetKind.BUNDLER_API_DEPENDENCIES.equals((Object)file.getKind())) {
            return this.getCachedBundlerGems(file);
        }
        return ((OrientRubygemsContentFacet)this.getRepository().facet(OrientRubygemsContentFacet.class)).get(file);
    }

    private Content getCachedBundlerGems(RubygemsFile file) throws IOException {
        if (file.getGems() == null) {
            return null;
        }
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        BundlerGems result = new BundlerGems();
        CacheInfo info = null;
        ArrayList<Asset> assets = new ArrayList<Asset>();
        for (String gem : file.getGems()) {
            Asset asset = tx.findAssetWithProperty("name", (Object)GemCoordinate.dependenciesPath(gem), tx.findBucket(this.getRepository()));
            if (asset == null) {
                this.log.trace("no dependencies for '{}'", (Object)gem);
                return null;
            }
            this.log.trace("loaded dependencies {}", (Object)asset);
            CacheInfo next = CacheInfo.extractFromAsset((Asset)asset);
            if (info == null || next != null && next.getLastVerified().isBefore((ReadableInstant)info.getLastVerified())) {
                info = next;
            }
            assets.add(asset);
            BundlerGems oneGem = OrientBundlerApiUtils.asBundlerGems(tx, asset);
            result.addAll(oneGem.getGems());
        }
        Content content = new Content((Payload)new BundlerGemsPayload(result));
        content.getAttributes().set("assetList", assets);
        content.getAttributes().set(CacheInfo.class, info);
        return content;
    }

    @TransactionalTouchMetadata
    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        this.setCacheInfo(content, cacheInfo);
    }

    private void setCacheInfo(Content content, CacheInfo cacheInfo) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent rubygems asset {}", content.getAttributes().require(Asset.class));
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)asset, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    @Nonnull
    protected CacheController getCacheController(@Nonnull Context context) {
        RubygemsFile file = this.getRubygemsFile(context);
        return this.cacheControllerHolder.require(file.getKind().getCacheType());
    }

    protected Content doGet(Context context, @Nullable Content staleContent) throws IOException {
        RubygemsFile file = this.getRubygemsFile(context);
        if (AssetKind.BUNDLER_API_DEPENDENCIES.equals((Object)file.getKind())) {
            if (file.getGems() != null && file.getGems().isEmpty()) {
                return new Content((Payload)EMPTY_BUNDLER_GEMS_PAYLOAD);
            }
            if (file.getGems() == null) {
                return new Content((Payload)EMPTY_PAYLOAD);
            }
        }
        Content content = super.doGet(context, staleContent);
        this.log.trace("get {} for {}", (Object)content, (Object)file);
        return content;
    }

    protected Content store(Context context, Content content) throws IOException {
        RubygemsFile file = this.getRubygemsFile(context);
        this.log.trace("store {} for {}", (Object)content, (Object)file);
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, OrientRubygemsCommonUtils.HASH_ALGORITHMS);){
            return this.doStore(file, content, tempBlob);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doStore(RubygemsFile file, Content content, TempBlob tempBlob) throws IOException {
        Asset asset;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        switch (file.getKind()) {
            case GEM: {
                asset = this.getComponentGemAsset(file, tx, bucket, (InputStreamSupplier)tempBlob);
                break;
            }
            case GEMSPEC: {
                asset = this.getComponentGemspecAsset(file, tx, bucket);
                break;
            }
            case GEM_INFO: 
            case SPECS_INDEX: 
            case VERSIONS: {
                asset = this.getAsset(file, tx, bucket);
                break;
            }
            case BUNDLER_API_DEPENDENCIES: {
                return this.handleBundlerDependencies(content, (InputStreamSupplier)tempBlob, tx, bucket);
            }
            default: {
                throw new IllegalStateException();
            }
        }
        AssetBlob blob = OrientRubygemsCommonUtils.updateAsset(tx, asset, content, tempBlob);
        Content newContent = new Content((Payload)new BlobPayload(blob.getBlob(), file.getKind() == AssetKind.SPECS_INDEX ? "application/gzip" : asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, OrientRubygemsCommonUtils.HASH_ALGORITHMS, (AttributesMap)newContent.getAttributes());
        return newContent;
    }

    private Content handleBundlerDependencies(Content content, InputStreamSupplier stream, StorageTx tx, Bucket bucket) throws IOException {
        BundlerGems gems;
        Throwable throwable = null;
        Object var7_7 = null;
        try (InputStream is = stream.get();){
            gems = Marshal.loadAs(is, BundlerGems.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        LinkedHashMap<String, BundlerGems> map = new LinkedHashMap<String, BundlerGems>();
        for (BundlerGem gem : gems.getGems()) {
            BundlerGems entry = (BundlerGems)map.get(gem.getName());
            if (entry == null) {
                entry = new BundlerGems();
                map.put(gem.getName(), entry);
            }
            entry.add(gem);
        }
        ArrayList<Asset> assets = new ArrayList<Asset>();
        for (Map.Entry entry : map.entrySet()) {
            this.log.trace("store dependencies {}", entry.getValue());
            Asset gemAsset = this.getBundlerGemAsset(GemCoordinate.dependenciesPath((String)entry.getKey()), tx, bucket);
            byte[] gemContent = Marshal.dumpAsBytes(entry.getValue());
            OrientRubygemsCommonUtils.updateAsset(tx, gemAsset, content, () -> new ByteArrayInputStream(gemContent));
            assets.add(gemAsset);
        }
        Content result = new Content((Payload)new BundlerGemsPayload(gems));
        result.getAttributes().set("assetList", assets);
        return result;
    }

    private Asset getBundlerGemAsset(String path, StorageTx tx, Bucket bucket) {
        Asset asset = OrientRubygemsCommonUtils.findAsset(tx, bucket, path);
        if (asset == null) {
            asset = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name(path);
            asset.formatAttributes().set("asset_kind", (Object)AssetKind.BUNDLER_API_DEPENDENCIES.name());
        }
        return asset;
    }

    private Asset getAsset(RubygemsFile file, StorageTx tx, Bucket bucket) {
        Asset assets = OrientRubygemsCommonUtils.findAsset(tx, bucket, file);
        if (assets == null) {
            assets = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name(file.getPath());
            assets.formatAttributes().set("asset_kind", (Object)file.getKind().name());
        }
        return assets;
    }

    protected Asset getComponentGemAsset(RubygemsFile file, StorageTx tx, Bucket bucket, InputStreamSupplier stream) throws IOException {
        Component component = OrientGemsUtils.getOrCreateGemComponent(tx, bucket, this.getRepository(), file.getCoordinate());
        GemSpecification gemspec = GemSpecificationUtils.retrieveGemSpecification(stream);
        return OrientGemsUtils.getOrCreateGemAsset(tx, bucket, component, gemspec);
    }

    private Asset getComponentGemspecAsset(RubygemsFile file, StorageTx tx, Bucket bucket) throws IOException {
        Component component = OrientGemsUtils.getOrCreateGemComponent(tx, bucket, this.getRepository(), file.getCoordinate());
        return OrientGemsUtils.getOrCreateGemspecAsset(tx, bucket, component, file.getCoordinate());
    }

    protected String getUrl(@Nonnull Context context) {
        return this.getRubygemsFile(context).getUrl();
    }

    @Nonnull
    private RubygemsFile getRubygemsFile(Context context) {
        return (RubygemsFile)((Object)context.getAttributes().require(RubygemsFile.class));
    }
}

