/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.orient.internal;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.orient.OrientRubygemsContentFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class OrientRubygemsContentHandler
extends ComponentSupport
implements Handler {
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String method = context.getRequest().getAction();
        Repository repository = context.getRepository();
        RubygemsFile file = this.getRubygemsFile(context);
        this.log.debug("{} repository '{}' - content: {}", new Object[]{method, repository.getName(), file});
        OrientRubygemsContentFacet facet = (OrientRubygemsContentFacet)repository.facet(OrientRubygemsContentFacet.class);
        switch (method) {
            case "HEAD": {
                if (file.getKind() == AssetKind.BUNDLER_API_DEPENDENCIES) {
                    return HttpResponses.ok();
                }
            }
            case "GET": {
                return this.handleGET(file, facet);
            }
            case "PUT": 
            case "POST": {
                return this.handlePUTandPOST(context, file, facet);
            }
            case "DELETE": {
                return this.handleDELETE(file, facet);
            }
        }
        return HttpResponses.methodNotAllowed((String)method, (String[])new String[]{"GET", "HEAD", "POST", "PUT", "DELETE"});
    }

    private Response handleDELETE(RubygemsFile file, OrientRubygemsContentFacet facet) throws IOException {
        if (file.getKind() == AssetKind.GEM && file.getCoordinate() != null) {
            facet.delete(file);
            return HttpResponses.noContent();
        }
        return HttpResponses.forbidden((String)"only gem files can be deleted");
    }

    private Response handlePUTandPOST(@Nonnull Context context, RubygemsFile file, OrientRubygemsContentFacet facet) throws IOException {
        if (file.getKind() == AssetKind.GEM) {
            facet.putGem(file.getCoordinate(), context.getRequest().getPayload());
            return HttpResponses.created();
        }
        return HttpResponses.forbidden((String)file.getPath());
    }

    private Response handleGET(@Nonnull RubygemsFile file, OrientRubygemsContentFacet facet) throws IOException {
        Content payload;
        switch (file.getKind()) {
            case BUNDLER_API_DEPENDENCIES: {
                payload = facet.getBundlerApiDependencies(file.getGems());
                break;
            }
            case SPECS_INDEX: {
                payload = facet.getOrCreateSpecsIndex(file);
                break;
            }
            default: {
                payload = facet.get(file);
            }
        }
        if (payload == null) {
            return HttpResponses.notFound((String)file.getPath());
        }
        return HttpResponses.ok((Payload)payload);
    }

    @Nonnull
    private RubygemsFile getRubygemsFile(Context context) {
        return (RubygemsFile)((Object)context.getAttributes().require(RubygemsFile.class));
    }
}

