/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.orient.internal;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.zip.DeflaterInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.internal.utils.GemSpecificationUtils;
import org.sonatype.nexus.repository.rubygems.marshal.GemRequirement;
import org.sonatype.nexus.repository.rubygems.marshal.GemSpecification;
import org.sonatype.nexus.repository.rubygems.marshal.Marshal;
import org.sonatype.nexus.repository.rubygems.orient.internal.OrientRubygemsCommonUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public class OrientGemsUtils {
    private static final Logger log = (Logger)Preconditions.checkNotNull((Object)Loggers.getLogger(OrientGemsUtils.class));

    private OrientGemsUtils() {
    }

    @NotNull
    public static Component getOrCreateGemComponent(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Repository repository, @NotNull GemCoordinate coordinate) {
        Component componentFound = OrientGemsUtils.getComponent(tx, repository, coordinate);
        if (componentFound != null) {
            return componentFound;
        }
        Component component = (Component)tx.createComponent(bucket, repository.getFormat()).version(coordinate.getGemVersion().getVersion()).name(coordinate.getName());
        log.trace("Created gem component: {} {}", (Object)component.name(), (Object)component.version());
        tx.saveComponent(component);
        return component;
    }

    @Nullable
    public static Component getComponent(StorageTx tx, Repository repository, GemCoordinate coordinate) {
        Iterable components = tx.findComponents(Query.builder().where("name").eq((Object)coordinate.getName()).and("version").eq((Object)coordinate.getGemVersion().getVersion()).build(), Collections.singletonList(repository));
        if (components.iterator().hasNext()) {
            return (Component)components.iterator().next();
        }
        return null;
    }

    @NotNull
    public static Asset getOrCreateGemAsset(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Component component, @NotNull GemCoordinate coordinate) {
        String storagePath = coordinate.gemPath();
        return OrientGemsUtils.getGemAsset(tx, bucket, component, AssetKind.GEM, coordinate, storagePath);
    }

    @NotNull
    public static Asset getOrCreateGemAsset(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Component component, @NotNull GemSpecification gemspec) {
        GemCoordinate coordinate = (GemCoordinate)Preconditions.checkNotNull((Object)gemspec.getCoordinate());
        String storagePath = coordinate.gemPath();
        Asset asset = OrientGemsUtils.getGemAsset(tx, bucket, component, AssetKind.GEM, coordinate, storagePath);
        OrientGemsUtils.applyGemspecAttributesToGem(asset, gemspec);
        NestedAttributesMap metadata = asset.formatAttributes().child("metadata");
        gemspec.getMetadata().forEach((arg_0, arg_1) -> ((AttributesMap)metadata).set(arg_0, arg_1));
        return asset;
    }

    public static void applyGemspecAttributesToGem(@NotNull Asset asset, @NotNull GemSpecification gemspec) {
        OrientGemsUtils.set(asset, "description", gemspec.getDescription());
        OrientGemsUtils.set(asset, "summary", gemspec.getSummary());
        OrientGemsUtils.set(asset, "homepage", gemspec.getHomepage());
        OrientGemsUtils.set(asset, "licenses", gemspec.getLicenses());
        OrientGemsUtils.set(asset, "emails", gemspec.getEmails());
        OrientGemsUtils.set(asset, "authors", gemspec.getAuthors());
        OrientGemsUtils.set(asset, "requirements", gemspec.getRequirements());
        OrientGemsUtils.set(asset, "executables", gemspec.getExecutables());
        OrientGemsUtils.set(asset, "created at", gemspec.getDate() == null ? null : gemspec.getDate().formatted());
        String requiredRubyVersion = Optional.of(gemspec).map(GemSpecification::getRequiredRubyVersion).orElse(GemRequirement.ALL).display();
        OrientGemsUtils.set(asset, "required ruby version", requiredRubyVersion);
        String requiredRubyGemsVersion = Optional.of(gemspec).map(GemSpecification::getRequiredRubygemsVersion).orElse(GemRequirement.ALL).display();
        OrientGemsUtils.set(asset, "required rubygems version", requiredRubyGemsVersion);
        OrientGemsUtils.set(asset, "dependencies", GemSpecificationUtils.createDependencyString(gemspec));
    }

    private static void set(Asset asset, String key, Object value) {
        if (value != null) {
            asset.formatAttributes().set(key, value);
        }
    }

    @NotNull
    public static Asset getOrCreateGemspecAsset(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Component component, @NotNull GemCoordinate coordinate) {
        return OrientGemsUtils.getGemAsset(tx, bucket, component, AssetKind.GEMSPEC, coordinate, coordinate.gemspecPath());
    }

    private static Asset getGemAsset(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Component component, @NotNull AssetKind kind, GemCoordinate coordinate, String storagePath) {
        Asset asset = tx.findAssetWithProperty("name", (Object)storagePath, component);
        if (asset == null) {
            asset = tx.createAsset(bucket, component);
            asset.name(storagePath);
            asset.formatAttributes().set("asset_kind", (Object)kind.name());
            asset.formatAttributes().set("platform", (Object)coordinate.getPlatform());
            log.trace("Created asset: {} for gem {} {}", new Object[]{asset, component.name(), component.version()});
        }
        return asset;
    }

    @NotNull
    public static String deleteGemspec(@NotNull StorageTx tx, @NotNull Component component, @NotNull GemCoordinate coordinate) {
        String storagePath = coordinate.gemspecPath();
        Asset asset = tx.findAssetWithProperty("name", (Object)storagePath, component);
        if (asset != null) {
            tx.deleteAsset(asset);
            log.trace("Deleted asset: {} for gem {} {}", new Object[]{asset, component.name(), component.version()});
            return asset.name();
        }
        return null;
    }

    @NotNull
    public static GemCoordinate toGemCoordinate(@NotNull Component gem, @NotNull Asset asset) {
        String name = gem.name();
        String version = gem.version();
        String platform = String.valueOf(asset.formatAttributes().get("platform"));
        return new GemCoordinate(name, version, platform);
    }

    public static void updateGemspec(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Component component, @NotNull GemSpecification gemspec) throws IOException {
        Asset asset = OrientGemsUtils.getOrCreateGemspecAsset(tx, bucket, component, gemspec.getCoordinate());
        byte[] bytes = Marshal.dumpAsBytes(gemspec);
        OrientRubygemsCommonUtils.updateAsset(tx, asset, () -> new DeflaterInputStream(new ByteArrayInputStream(bytes)));
    }

    public static Asset updateGem(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Component component, @NotNull GemSpecification gemspec, @NotNull TempBlob tempBlob) throws IOException {
        Asset asset = OrientGemsUtils.getOrCreateGemAsset(tx, bucket, component, gemspec);
        OrientRubygemsCommonUtils.updateAsset(tx, asset, null, tempBlob);
        return asset;
    }

    public static Asset updateGem(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Component component, @NotNull GemSpecification gemspec, @Nonnull AssetBlob assetBlob) throws IOException {
        Asset asset = OrientGemsUtils.getOrCreateGemAsset(tx, bucket, component, gemspec);
        OrientRubygemsCommonUtils.updateAsset(tx, asset, assetBlob, null);
        return asset;
    }
}

