/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.orient;

import com.google.common.hash.HashCode;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;

@Named
public class OrientRubyBundlerEtagHandler
extends ComponentSupport
implements Handler {
    public Response handle(Context context) throws Exception {
        Response response = context.proceed();
        if (response.getStatus().getCode() != 200) {
            return response;
        }
        Payload payload = response.getPayload();
        if (payload instanceof Content) {
            Content content = (Content)payload;
            Optional.ofNullable((Map)content.getAttributes().get("hashCodesMap", Content.T_CONTENT_HASH_CODES_MAP)).map(checksums -> (HashCode)checksums.get(HashAlgorithm.MD5)).map(HashCode::toString).ifPresent(md5 -> {
                Object object = content.getAttributes().set("etag", md5);
            });
        } else {
            this.log.debug("Result is not an instance of Payload for {}", (Object)context);
        }
        return response;
    }
}

