/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.marshal;

import com.google.common.primitives.Bytes;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.sonatype.nexus.repository.rubygems.marshal.MarshalDump;
import org.sonatype.nexus.repository.rubygems.marshal.MarshalLoad;
import org.sonatype.nexus.repository.rubygems.marshal.Marshaled;

public class Marshal {
    private Marshal() {
    }

    public static List<Byte> dump(Object object) throws IOException {
        return Bytes.asList((byte[])Marshal.dumpAsBytes(object));
    }

    public static InputStream dumpAsInputStream(Object object) throws IOException {
        return new ByteArrayInputStream(Marshal.dumpAsBytes(object));
    }

    public static byte[] dumpAsBytes(Object object) throws IOException {
        return new MarshalDump().toBytes(object);
    }

    public static Object load(InputStream is) throws IOException {
        return new MarshalLoad().fromBytes(is);
    }

    public static <T extends Marshaled<?>> T loadAs(InputStream is, Class<T> clazz) throws IOException {
        return new MarshalLoad().fromBytesAs(is, clazz);
    }

    public static Object load(byte[] bytes) throws IOException {
        return new MarshalLoad().fromBytes(bytes);
    }

    public static <T extends Marshaled<?>> T loadAs(byte[] bytes, Class<T> clazz) throws IOException {
        return new MarshalLoad().fromBytesAs(bytes, clazz);
    }
}

