/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.marshal;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonatype.nexus.repository.rubygems.marshal.GemVersion;
import org.sonatype.nexus.repository.rubygems.marshal.RubyString;
import org.sonatype.nexus.repository.rubygems.marshal.UserMarshaled;

public class GemRequirement
extends UserMarshaled<List<List<Object>>> {
    private static final Pattern CONSTRAINT = Pattern.compile("^([^0-9\\s]+)\\s*([0-9].*)$");
    public static final GemRequirement ALL = new GemRequirement(new String[]{">= 0"});
    public static final int RELATION = 0;
    public static final int VERSION = 1;

    public GemRequirement() {
        super("Gem::Requirement");
        this.setData(new LinkedList());
    }

    public GemRequirement(Map<String, List<List<Object>>> data) {
        this();
        Preconditions.checkNotNull(data);
        List<List<Object>> constraints = data.get("requirements");
        for (List<Object> item : constraints) {
            GemVersion version = new GemVersion((Map)item.get(1));
            this.addConstraint((String)item.get(0), version);
        }
    }

    GemRequirement(String ... constraints) {
        this();
        String[] stringArray = constraints;
        int n = constraints.length;
        int n2 = 0;
        while (n2 < n) {
            String constraint = stringArray[n2];
            ((List)this.getData()).add(this.getConstraintObject(constraint.trim()));
            ++n2;
        }
    }

    private List<Object> getConstraintObject(String constraint) {
        Preconditions.checkNotNull((Object)constraint);
        Matcher matcher = CONSTRAINT.matcher(constraint);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("can not constraint: " + constraint);
        }
        return Arrays.asList(new RubyString(matcher.group(1)), new GemVersion(matcher.group(2)));
    }

    private void addConstraint(String relation, GemVersion version) {
        ((List)this.getData()).add(Arrays.asList(new RubyString(relation), version));
    }

    public String[] versionConstraints() {
        List constraints = (List)this.getData();
        String[] result = new String[constraints.size()];
        int i = 0;
        for (List constraint : constraints) {
            result[i++] = constraint.get(0) + " " + ((GemVersion)constraint.get(1)).getVersion();
        }
        return result;
    }

    public String display() {
        return String.join((CharSequence)",", this.versionConstraints());
    }

    public static GemRequirement parseDisplay(String displayString) {
        return new GemRequirement(displayString.split(","));
    }
}

