/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.marshal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.rubygems.marshal.IVar;
import org.sonatype.nexus.repository.rubygems.marshal.RawString;
import org.sonatype.nexus.repository.rubygems.marshal.RubyObject;
import org.sonatype.nexus.repository.rubygems.marshal.RubyString;
import org.sonatype.nexus.repository.rubygems.marshal.Symbol;

public class GemPlatform
extends RubyObject {
    @VisibleForTesting
    static final Symbol CPU = Symbol.create("@cpu");
    @VisibleForTesting
    static final Symbol OS = Symbol.create("@os");
    @VisibleForTesting
    static final Symbol VERSION = Symbol.create("@version");
    public static GemPlatform RUBY = GemPlatform.parse("ruby");

    private GemPlatform() {
        super("Gem::Platform");
    }

    public GemPlatform(@Nullable String cpu, String os, @Nullable String version) {
        this();
        Preconditions.checkNotNull((Object)os);
        this.put(VERSION, RubyString.create(version));
        this.put(OS, new RubyString(os));
        this.put(CPU, RubyString.create(cpu));
    }

    public IVar<?> getCpu() {
        return GemPlatform.castIVar(this.get(CPU));
    }

    public IVar<?> getOs() {
        return GemPlatform.castIVar(this.get(OS));
    }

    public IVar<?> getVersion() {
        return GemPlatform.castIVar(this.get(VERSION));
    }

    public String toPlatformString() {
        StringBuilder result = new StringBuilder();
        Optional.ofNullable(this.getCpu()).ifPresent(cpu -> {
            StringBuilder stringBuilder2 = result.append(cpu).append('-');
        });
        result.append(this.getOs());
        Optional.ofNullable(this.getVersion()).ifPresent(version -> {
            StringBuilder stringBuilder2 = result.append('-').append(version);
        });
        return result.toString();
    }

    private static IVar<?> castIVar(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof IVar) {
            return (IVar)o;
        }
        if (o instanceof RawString) {
            return new RubyString((RawString)o);
        }
        throw new IllegalArgumentException("Unexpected object of type: " + o.getClass());
    }

    public static GemPlatform parse(String platform) {
        Preconditions.checkNotNull((Object)platform);
        String version = null;
        String os = null;
        String cpu = null;
        if (platform.contains("-")) {
            String[] parts = platform.split("-");
            Preconditions.checkArgument((parts.length == 3 || parts.length == 2 ? 1 : 0) != 0, (Object)("platform string needs none, one or two '-': " + platform));
            if (parts.length == 3) {
                version = parts[2];
            }
            os = parts[1];
            cpu = parts[0];
        } else {
            os = platform;
        }
        return new GemPlatform(cpu, os, version);
    }
}

