/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.marshal;

import java.util.LinkedList;
import java.util.List;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerGem;
import org.sonatype.nexus.repository.rubygems.marshal.Marshaled;

public class BundlerGems
implements Marshaled<Object> {
    public static BundlerGems EMPTY = new BundlerGems();
    private List<BundlerGem> gems = new LinkedList<BundlerGem>();

    public void add(BundlerGem dependency) {
        if (!this.gems.contains(dependency)) {
            this.gems.add(dependency);
        }
    }

    public void addAll(List<BundlerGem> dependencies) {
        dependencies.forEach(this::add);
    }

    public List<BundlerGem> getGems() {
        return this.gems;
    }

    public void removeAll(String name, String version) {
        this.gems.removeIf(gem -> gem.getName().equals(name) && gem.getVersion().equals(version));
    }

    public void remove(BundlerGem gem) {
        this.gems.remove(gem);
    }

    @Override
    public Object marshalDump() {
        return this.gems;
    }

    @Override
    public void marshalLoad(Object data) {
        List newList = (List)data;
        if (newList.isEmpty() || newList.get(0) instanceof BundlerGem) {
            this.gems = newList;
        } else {
            this.gems = new LinkedList<BundlerGem>();
            for (Object obj : newList) {
                BundlerGem gem = new BundlerGem();
                gem.marshalLoad(obj);
                this.gems.add(gem);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundlerGems that = (BundlerGems)o;
        return !(this.gems != null ? !this.gems.equals(that.gems) : that.gems != null);
    }

    public int hashCode() {
        return this.gems != null ? this.gems.hashCode() : 0;
    }

    public String toString() {
        return this.gems.toString();
    }
}

