/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal.hosted;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.rubygems.internal.hosted.VersionsHostedFacet;
import org.sonatype.nexus.scheduling.ExternalTaskState;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Once;
import org.sonatype.nexus.scheduling.schedule.Schedule;

public abstract class VersionsHostedFacetSupport
extends FacetSupport
implements VersionsHostedFacet {
    private TaskScheduler taskScheduler;
    private Duration rebuildDelay;
    private Cooperation2Factory.Builder cooperationBuilder;
    protected Cooperation2 cooperation;

    @Inject
    public void init(TaskScheduler taskScheduler, Cooperation2Factory cooperationFactory, @Named(value="${nexus.ruby.versions.rebuild.delay:-60s}") @Named(value="${nexus.ruby.versions.rebuild.delay:-60s}") Duration rebuildDelay, @Named(value="${nexus.ruby.versions.cooperation.enabled:-true}") @Named(value="${nexus.ruby.versions.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.ruby.versions.cooperation.majorTimeout:-0s}") @Named(value="${nexus.ruby.versions.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.ruby.versions.cooperation.minorTimeout:-30s}") @Named(value="${nexus.ruby.versions.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.ruby.versions.cooperation.threadsPerKey:-100}") @Named(value="${nexus.ruby.versions.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.rebuildDelay = (Duration)Preconditions.checkNotNull((Object)rebuildDelay);
        this.cooperationBuilder = ((Cooperation2Factory)Preconditions.checkNotNull((Object)cooperationFactory)).configure().enabled(cooperationEnabled).majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
    }

    protected void doStart() throws Exception {
        this.cooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":versions");
    }

    @Override
    @Guarded(by={"STARTED"})
    public void maybeScheduleRebuild() {
        this.log.debug("Maybe scheduling rebuild for {}", (Object)this.getRepository().getName());
        try {
            TaskInfo taskInfo = (TaskInfo)this.cooperation.on(() -> this.scheduleBuild()).checkFunction(() -> this.getScheduledTask()).performWorkOnFail(false).cooperate("task", new String[0]);
            this.log.debug("Found or scheduled task {}", (Object)taskInfo);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.warn("Failed to schedule rebuild of metadata for repository {}", (Object)this.getRepository().getName(), (Object)e);
            }
            this.log.warn("Failed to schedule rebuild of metadata for repository {} cause: {}", (Object)this.getRepository().getName(), (Object)e.getMessage());
        }
    }

    private TaskInfo scheduleBuild() {
        this.log.debug("Attempting to schedule task");
        return this.getScheduledTask().orElseGet(() -> {
            this.log.debug("Scheduling new task for repository {}", (Object)this.getRepository().getName());
            TaskConfiguration taskConfiguration = this.taskScheduler.createTaskConfigurationInstance("repository.ruby.automated.rebuild.versions");
            taskConfiguration.setName("Rebuild versions for " + this.getRepository().getName());
            taskConfiguration.setString("repositoryName", this.getRepository().getName());
            long time = OffsetDateTime.now().plus(this.rebuildDelay).toInstant().toEpochMilli();
            return this.taskScheduler.scheduleTask(taskConfiguration, (Schedule)new Once(new Date(time)));
        });
    }

    private Optional<TaskInfo> getScheduledTask() {
        return this.taskScheduler.listsTasks().stream().filter(task -> "repository.ruby.automated.rebuild.versions".equals(task.getTypeId())).peek(task -> this.log.trace("Matching type: {}", task)).filter(this::isForSameRepository).peek(task -> this.log.trace("Matching repository: {}", task)).filter(this::isTaskNotDone).peek(task -> this.log.trace("Found existing task: {}", task)).findAny();
    }

    private boolean isForSameRepository(TaskInfo task) {
        return this.getRepository().getName().equals(task.getConfiguration().getString("repositoryName"));
    }

    private boolean isTaskNotDone(TaskInfo task) {
        ExternalTaskState externalTaskState = this.taskScheduler.toExternalTaskState(task);
        this.log.debug("Found state {} for task {}", (Object)externalTaskState, (Object)task);
        return !externalTaskState.getState().isDone();
    }
}

