/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal.hosted;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsFormat;
import org.sonatype.nexus.repository.rubygems.internal.hosted.VersionsHostedFacet;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.scheduling.Cancelable;

public class RebuildVersionsTask
extends RepositoryTaskSupport
implements Cancelable {
    public String getMessage() {
        return "Rebuild versions for " + this.getRepositoryField();
    }

    protected void execute(Repository repository) {
        try {
            boolean force = this.getConfiguration().getBoolean("forceRebuild", false);
            ((VersionsHostedFacet)repository.facet(VersionsHostedFacet.class)).rebuild(force);
        }
        catch (IOException e) {
            this.log.error("Failed to rebuild versions metadata for {}", (Object)repository.getName(), (Object)e);
            throw new UncheckedIOException(e);
        }
    }

    protected boolean appliesTo(Repository repository) {
        return repository.getFormat() instanceof RubygemsFormat && repository.getType() instanceof HostedType;
    }
}

