/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal.hosted;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.rubygems.marshal.GemRequirement;
import org.sonatype.nexus.repository.view.Content;

@Facet.Exposed
public interface GemInfoHostedFacet
extends Facet {
    public Optional<Content> get(String var1) throws IOException;

    @Nullable
    public Content rebuild(String var1) throws IOException;

    public void markForRebuild(String var1);

    default public String createVersionLine(String gemVersion, String platform, String dependencies, String sha256Checksum, @Nullable String requiredRubyVersionStr, @Nullable String requiredRubygemsVersionStr) {
        StringBuilder sb = new StringBuilder();
        sb.append(gemVersion);
        if (platform != null && !platform.isEmpty() && !platform.equals("ruby")) {
            sb.append('-').append(platform);
        }
        sb.append(' ');
        sb.append(dependencies).append('|');
        sb.append("checksum:").append(sha256Checksum);
        GemInfoHostedFacet.toRequirement(requiredRubyVersionStr).ifPresent(req -> {
            StringBuilder stringBuilder2 = sb.append(",ruby:").append((String)req);
        });
        GemInfoHostedFacet.toRequirement(requiredRubygemsVersionStr).ifPresent(req -> {
            StringBuilder stringBuilder2 = sb.append(",rubygems:").append((String)req);
        });
        return sb.toString();
    }

    public static Optional<String> toRequirement(@Nullable String requirementString) {
        return Optional.ofNullable(requirementString).map(GemRequirement::parseDisplay).filter(((Predicate<GemRequirement>)GemRequirement.ALL::equals).negate()).map(req -> req.versionConstraints()).map(arg_0 -> ((Joiner)Joiner.on((char)'&')).join(arg_0));
    }
}

