/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal.hosted;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.inject.Inject;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsFormat;
import org.sonatype.nexus.repository.rubygems.internal.hosted.VersionsHostedFacet;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@TaskLogging(value=TaskLogType.NEXUS_LOG_ONLY)
public class AutomatedRebuildVersionsTask
extends RepositoryTaskSupport
implements Cancelable {
    private final PeriodicJobService jobService;

    @Inject
    public AutomatedRebuildVersionsTask(PeriodicJobService jobService) {
        super(false);
        this.jobService = (PeriodicJobService)Preconditions.checkNotNull((Object)jobService);
    }

    public String getMessage() {
        return "Automatic rubygems metadata rebuild";
    }

    protected void execute(Repository repository) {
        boolean force = this.getConfiguration().getBoolean("forceRebuild", false);
        this.log.debug("Maybe rebuilding versions metadata for {} with force={}", (Object)repository.getName(), (Object)force);
        try {
            ((VersionsHostedFacet)repository.facet(VersionsHostedFacet.class)).rebuild(force);
            this.triggerFollowupCheck(repository);
        }
        catch (IOException e) {
            this.log.warn("An error occurred rebuilding RubyGems versions file in {}", (Object)repository.getName(), (Object)(this.log.isDebugEnabled() ? e : null));
            throw new UncheckedIOException(e);
        }
    }

    private void triggerFollowupCheck(Repository repository) {
        try {
            this.jobService.startUsing();
            this.jobService.runOnce(() -> this.followupCheck(repository), 1);
        }
        catch (Exception e) {
            this.log.warn("Unable to setup verification: {}", (Object)e.getMessage(), (Object)(this.log.isDebugEnabled() ? e : null));
        }
    }

    private void followupCheck(Repository repository) {
        block12: {
            try {
                try {
                    this.log.debug("Following up {} versions", (Object)repository.getName());
                    if (((VersionsHostedFacet)repository.facet(VersionsHostedFacet.class)).needsRebuild()) {
                        this.log.debug("Scheduling another build for {}", (Object)repository.getName());
                        ((VersionsHostedFacet)repository.facet(VersionsHostedFacet.class)).maybeScheduleRebuild();
                    }
                }
                catch (Exception e) {
                    this.log.warn("An error occurred verifying repository rebuild: {}", (Object)e.getMessage(), (Object)(this.log.isDebugEnabled() ? e : null));
                    try {
                        this.jobService.stopUsing();
                    }
                    catch (Exception e2) {
                        this.log.warn("Unable to stop using job service: {}", (Object)e2.getMessage(), (Object)(this.log.isDebugEnabled() ? e2 : null));
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.jobService.stopUsing();
                }
                catch (Exception e) {
                    this.log.warn("Unable to stop using job service: {}", (Object)e.getMessage(), (Object)(this.log.isDebugEnabled() ? e : null));
                }
                throw throwable;
            }
            try {
                this.jobService.stopUsing();
            }
            catch (Exception e) {
                this.log.warn("Unable to stop using job service: {}", (Object)e.getMessage(), (Object)(this.log.isDebugEnabled() ? e : null));
            }
        }
    }

    protected boolean appliesTo(Repository repository) {
        return repository.getFormat() instanceof RubygemsFormat && repository.getType() instanceof HostedType;
    }
}

