/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal.group;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.repository.group.SingleMetadataMergingGroupHandlerSupport;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsGroupFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class VersionsGroupHandler
extends SingleMetadataMergingGroupHandlerSupport {
    @Inject
    public void configure(Cooperation2Factory cooperationFactory, @Named(value="${nexus.ruby.group.merge.cooperation.enabled:-true}") @Named(value="${nexus.ruby.group.merge.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.ruby.group.merge.cooperation.majorTimeout:-0s}") @Named(value="${nexus.ruby.group.merge.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.ruby.group.merge.cooperation.minorTimeout:-30s}") @Named(value="${nexus.ruby.group.merge.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.ruby.group.merge.cooperation.threadsPerKey:-100}") @Named(value="${nexus.ruby.group.merge.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        super.configureCooperation(cooperationFactory, cooperationEnabled, majorTimeout, minorTimeout, threadsPerKey);
    }

    protected Optional<Content> getCached(Context context) {
        return ((RubygemsGroupFacet)context.getRepository().facet(RubygemsGroupFacet.class)).versions();
    }

    protected Content store(Context context, Content content) throws IOException {
        return ((RubygemsGroupFacet)context.getRepository().facet(RubygemsGroupFacet.class)).putVersions(content);
    }

    protected String[] cooperationKey(Context context) {
        return new String[]{"versions"};
    }

    protected Optional<Payload> merge(Collection<Response> responses) {
        OffsetDateTime start = OffsetDateTime.now(ZoneOffset.UTC);
        LinkedHashSet rows = new LinkedHashSet();
        for (Response response : responses) {
            this.log.debug("Merging response {}", (Object)response);
            try {
                Payload payload = response.getPayload();
                if (payload == null) {
                    this.log.warn("Member repository returned no content");
                    continue;
                }
                Throwable throwable = null;
                Object var8_10 = null;
                try {
                    BufferedInputStream in = new BufferedInputStream(payload.openInputStream());
                    try {
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                            reader.lines().filter(VersionsGroupHandler.skipUntil("---"::equals)).forEach(rows::add);
                        }
                        if (in == null) continue;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                        throw throwable;
                    }
                    ((InputStream)in).close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("created_at: ").append(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(start)).append('\n').append("---").append('\n');
        rows.forEach(row -> {
            StringBuilder stringBuilder2 = sb.append((String)row).append('\n');
        });
        return Optional.of(new StringPayload(sb.toString(), "text/plain"));
    }
}

