/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal.group;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.repository.group.SingleMetadataMergingGroupHandlerSupport;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsGroupFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class GemInfoGroupHandler
extends SingleMetadataMergingGroupHandlerSupport {
    @Inject
    public void configure(Cooperation2Factory cooperationFactory, @Named(value="${nexus.ruby.group.merge.cooperation.enabled:-true}") @Named(value="${nexus.ruby.group.merge.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.ruby.group.merge.cooperation.majorTimeout:-0s}") @Named(value="${nexus.ruby.group.merge.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.ruby.group.merge.cooperation.minorTimeout:-30s}") @Named(value="${nexus.ruby.group.merge.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.ruby.group.merge.cooperation.threadsPerKey:-100}") @Named(value="${nexus.ruby.group.merge.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        super.configureCooperation(cooperationFactory, cooperationEnabled, majorTimeout, minorTimeout, threadsPerKey);
    }

    protected Optional<Content> getCached(Context context) {
        return ((RubygemsGroupFacet)context.getRepository().facet(RubygemsGroupFacet.class)).gemInfo(this.getGemName(context));
    }

    protected Content store(Context context, Content content) throws IOException {
        return ((RubygemsGroupFacet)context.getRepository().facet(RubygemsGroupFacet.class)).putGemInfo(this.getGemName(context), content);
    }

    protected String[] cooperationKey(Context context) {
        return new String[]{this.getGemName(context)};
    }

    private String getGemName(Context context) {
        RubygemsFile file = (RubygemsFile)((Object)Preconditions.checkNotNull((Object)((Object)((RubygemsFile)((Object)context.getAttributes().get(RubygemsFile.class))))));
        Preconditions.checkArgument((file.getKind() == AssetKind.GEM_INFO ? 1 : 0) != 0);
        List<String> gems = file.getGems();
        Preconditions.checkArgument((gems != null && gems.size() == 1 ? 1 : 0) != 0, (Object)"Missing gem name");
        return (String)Iterables.getFirst(gems, null);
    }

    protected Optional<Payload> merge(Collection<Response> responses) {
        LinkedHashMap<String, GemInfo> result = new LinkedHashMap<String, GemInfo>();
        for (Response response : responses) {
            this.log.debug("Merging response {}", (Object)response);
            try {
                Payload payload = response.getPayload();
                if (payload == null) {
                    this.log.warn("Member repository returned no content");
                    continue;
                }
                Throwable throwable = null;
                Object var7_9 = null;
                try {
                    BufferedInputStream in = new BufferedInputStream(payload.openInputStream());
                    try {
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                            reader.lines().filter(GemInfoGroupHandler.skipUntil("---"::equals)).map(this::toGemInfo).filter(Objects::nonNull).forEachOrdered(gemInfo -> {
                                GemInfo gemInfo2 = result.putIfAbsent(((GemInfo)gemInfo).version, (GemInfo)gemInfo);
                            });
                        }
                        if (in == null) continue;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                        throw throwable;
                    }
                    ((InputStream)in).close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.log.error("An error occurred while creating geminfo {}", (Object)e.getMessage());
                throw new UncheckedIOException(e);
            }
        }
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new StringPayload(this.serialize(result), "text/plain"));
    }

    private String serialize(Map<String, GemInfo> result) {
        StringBuilder sb = new StringBuilder().append("---").append('\n');
        result.values().stream().forEachOrdered(gemInfo -> {
            StringBuilder stringBuilder2 = sb.append(((GemInfo)gemInfo).line).append('\n');
        });
        return sb.toString();
    }

    private GemInfo toGemInfo(String line) {
        String[] segments = line.split("\\|");
        if (segments.length != 2) {
            this.log.warn("Skipping geminfo entry {}", (Object)line);
            return null;
        }
        return new GemInfo(segments[0].trim(), line);
    }

    private static class GemInfo {
        private final String version;
        private final String line;

        GemInfo(String version, String extra) {
            this.version = version;
            this.line = extra;
        }
    }
}

