/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;

public class GZippedTempStreamSupplier
extends ComponentSupport
implements AutoCloseable,
InputStreamSupplier {
    private final Path tempFile = Files.createTempFile("", "", new FileAttribute[0]);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GZippedTempStreamSupplier(InputStream inputStream) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            GZIPOutputStream outputStream = new GZIPOutputStream(Files.newOutputStream(this.tempFile, new OpenOption[0]));
            try {
                try (InputStream in = inputStream;){
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                if (outputStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (outputStream == null) throw throwable;
                ((OutputStream)outputStream).close();
                throw throwable;
            }
            ((OutputStream)outputStream).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Override
    public void close() {
        try {
            Files.delete(this.tempFile);
        }
        catch (IOException e) {
            this.log.warn("Unable to delete temp file {}", (Object)this.tempFile, (Object)e);
        }
    }

    @Nonnull
    public InputStream get() {
        try {
            return Files.newInputStream(this.tempFile, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

