/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal.upgrade;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.UpgradeTaskScheduler;
import org.sonatype.nexus.upgrade.datastore.RepeatableDatabaseMigrationStep;

@Named
@Singleton
public class RubygemsHostedMarkDirtyGemInfoMigrationStep
extends RepeatableDatabaseMigrationStep {
    private final TaskScheduler taskScheduler;
    private final UpgradeTaskScheduler upgradeTaskScheduler;

    @Inject
    public RubygemsHostedMarkDirtyGemInfoMigrationStep(TaskScheduler ts, UpgradeTaskScheduler uts) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)ts);
        this.upgradeTaskScheduler = (UpgradeTaskScheduler)Preconditions.checkNotNull((Object)uts);
    }

    public Integer getChecksum() {
        return 1;
    }

    public void migrate(Connection connection) throws Exception {
        this.log.info("Scheduling post-startup task to mark rubygems hosted info files dirty");
        String repositories = String.join((CharSequence)",", this.getHostedRubygemsRepositories(connection));
        this.log.debug("Rubygems hosted repositories found: {}", (Object)repositories);
        if (StringUtils.isBlank((String)repositories)) {
            return;
        }
        this.scheduleMarkDirtyInfoFilesTask(repositories);
    }

    private void scheduleMarkDirtyInfoFilesTask(String repositories) {
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("repository.ruby.mark.dirty.gem.info");
        configuration.setString("repositoryName", repositories);
        this.upgradeTaskScheduler.schedule(configuration);
        this.log.debug("Post-startup task to mark rubygems hosted info files dirty has been scheduled for: {}", (Object)repositories);
    }

    private List<String> getHostedRubygemsRepositories(Connection connection) throws SQLException {
        LinkedList repositories = Lists.newLinkedList();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Statement s = connection.createStatement();){
            String query = "SELECT name FROM repository WHERE recipe_name = 'rubygems-hosted'";
            ResultSet rs = s.executeQuery(query);
            while (rs.next()) {
                repositories.add(rs.getString(1));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return repositories;
    }
}

