/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal.hosted;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Named;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.event.asset.AssetCreatedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentDeletedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentPurgedEvent;
import org.sonatype.nexus.repository.content.store.ContentStoreEvent;
import org.sonatype.nexus.repository.rubygems.datastore.RubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.internal.hosted.GemInfoHostedFacet;
import org.sonatype.nexus.repository.rubygems.internal.hosted.VersionsHostedFacet;
import org.sonatype.nexus.repository.rubygems.internal.hosted.VersionsHostedFacetSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
public class VersionsHostedFacetImpl
extends VersionsHostedFacetSupport
implements VersionsHostedFacet,
EventAware.Asynchronous {
    @Override
    public Optional<Content> get() throws IOException {
        Optional<Content> result = this.content().versions();
        if (result.isPresent()) {
            return result;
        }
        return Optional.ofNullable(this.rebuild());
    }

    @Override
    public Content rebuild() throws IOException {
        this.log.debug("Starting rebuild for {}", (Object)this.getRepository().getName());
        return (Content)this.cooperation.on(this::doRebuild).checkFunction(this.content()::versions).cooperate("versions", new String[0]);
    }

    @Override
    public Content rebuild(boolean force) throws IOException {
        if (!force) {
            Optional<Content> existing = this.content().versions();
            if (!this.content().isVersionsDirty() && existing.isPresent()) {
                this.log.debug("Skipping rebuild as the file is up to date in {}", (Object)this.getRepository().getName());
                return existing.get();
            }
        }
        return this.rebuild();
    }

    private Content doRebuild() throws IOException {
        this.log.debug("Rebuild in progress");
        OffsetDateTime start = OffsetDateTime.now();
        StringBuilder sb = new StringBuilder();
        sb.append("created_at: ").append(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(start)).append('\n');
        sb.append("---\n");
        this.content().components().names("").forEach(gemName -> this.append(sb, (String)gemName, this.versions((String)gemName), this.checksum((String)gemName)));
        return this.content().putVersions((Payload)new StringPayload(sb.toString(), "text/plain"), start);
    }

    private void append(StringBuilder sb, String gemName, Collection<String> versions, String checksum) {
        CancelableHelper.checkCancellation();
        if (versions.size() == 0) {
            this.log.debug("Skipping {} as no versions were found", (Object)gemName);
            return;
        }
        sb.append(gemName).append(' ');
        for (String version : versions) {
            sb.append(version).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(' ');
        if (checksum != null) {
            sb.append(checksum);
        } else {
            sb.append("unknown");
        }
        sb.append('\n');
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetCreatedEvent event) {
        if (this.isRelevant((ContentStoreEvent)event)) {
            this.log.debug("Processing event {}", (Object)event);
            this.content().markVersionsForRebuild();
            this.maybeScheduleRebuild();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(ComponentDeletedEvent event) {
        if (this.isRelevant((ContentStoreEvent)event)) {
            this.log.debug("Processing event {}", (Object)event);
            this.content().markVersionsForRebuild();
            this.maybeScheduleRebuild();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(ComponentPurgedEvent event) {
        if (this.isRelevant((ContentStoreEvent)event)) {
            this.log.debug("Processing event {}", (Object)event);
            this.content().markVersionsForRebuild();
            this.maybeScheduleRebuild();
        }
    }

    private RubygemsContentFacet content() {
        return (RubygemsContentFacet)this.getRepository().facet(RubygemsContentFacet.class);
    }

    private boolean isRelevant(ContentStoreEvent event) {
        return event.getRepository().map(this.getRepository()::equals).orElse(false);
    }

    @Override
    public boolean needsRebuild() {
        return this.content().isVersionsDirty();
    }

    private Collection<String> versions(String gemName) {
        return this.content().components().versions("", gemName);
    }

    private String checksum(String gemName) {
        try {
            return ((GemInfoHostedFacet)this.getRepository().facet(GemInfoHostedFacet.class)).get(gemName).map(Content::getAttributes).map(attr -> (Asset)attr.get(Asset.class)).flatMap(Asset::blob).map(AssetBlob::checksums).map(checksums -> (String)checksums.get(HashAlgorithm.MD5.name())).orElse(null);
        }
        catch (IOException e) {
            this.log.warn("An error occurred while retrieving the checksum for {} in {}", new Object[]{gemName, this.getRepository().getName(), this.log.isDebugEnabled() ? e : null});
            return null;
        }
    }
}

