/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal.hosted;

import com.google.common.base.Stopwatch;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.datastore.RubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.internal.hosted.UpdateRubygemsAttributesTask;
import org.sonatype.nexus.repository.rubygems.internal.utils.GemSpecificationUtils;
import org.sonatype.nexus.repository.rubygems.marshal.GemSpecification;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
@TaskLogging(value=TaskLogType.TASK_LOG_ONLY_WITH_PROGRESS)
public class UpdateRubygemsAttributesTaskImpl
extends RepositoryTaskSupport
implements UpdateRubygemsAttributesTask {
    private final Stopwatch sw = Stopwatch.createUnstarted();
    private ProgressLogIntervalHelper progressLogger;
    private int processed = 0;
    private int failed = 0;
    private int skipped = 0;

    public String getMessage() {
        return "Rebuilding attributes for RubyGems";
    }

    protected void execute(Repository repository) {
        this.log.info("Starting repository {}", (Object)repository.getName());
        this.processed = 0;
        this.failed = 0;
        this.skipped = 0;
        this.progressLogger = new ProgressLogIntervalHelper(this.log, 60);
        try {
            this.sw.start();
            Continuations.streamOf((arg_0, arg_1) -> ((FluentQuery)this.content(repository).assets().byKind(AssetKind.GEM.name())).browse(arg_0, arg_1)).forEach(this::update);
        }
        finally {
            this.progressLogger.close();
            this.sw.reset();
        }
    }

    private void update(FluentAsset asset) {
        CancelableHelper.checkCancellation();
        if (!asset.hasBlob()) {
            this.log.debug("Skipping {} as it has no blob", (Object)asset.path());
            ++this.skipped;
            return;
        }
        this.log.debug("Processing {}", (Object)asset.path());
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Content content = asset.download();){
                GemSpecification spec = GemSpecificationUtils.retrieveGemSpecification(() -> ((Content)content).openInputStream());
                asset.attributes(AttributeOperation.OVERLAY, "rubygems", GemSpecificationUtils.getGemSpecificationAttributes(spec));
                ++this.processed;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.warn("Failed to process path {} error: {}", new Object[]{asset.path(), e.getMessage(), this.log.isDebugEnabled() ? e : null});
            ++this.failed;
        }
        this.progressLogger.info("Processed {} skipped {} failed {} elapsed {} sec", new Object[]{this.processed, this.skipped, this.failed, this.sw});
    }

    private RubygemsContentFacet content(Repository repository) {
        return (RubygemsContentFacet)repository.facet(RubygemsContentFacet.class);
    }

    protected boolean appliesTo(Repository repository) {
        return "rubygems".equals(repository.getFormat().getValue()) && !this.isGroupRepository(repository);
    }
}

