/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal.hosted;

import com.google.common.collect.ImmutableMap;
import java.time.OffsetDateTime;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.fluent.FluentAttributes;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.datastore.RubygemsContentFacet;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.Task;

@Named
public class RubygemsHostedMarkDirtyGemInfoTask
extends RepositoryTaskSupport
implements Task,
Cancelable {
    public String getMessage() {
        return "Marking dirty gem infos for RubyGems";
    }

    protected boolean appliesTo(Repository repository) {
        return "rubygems".equals(repository.getFormat().getValue()) && "hosted".equals(repository.getType().getValue());
    }

    protected void execute(Repository repository) {
        this.log.debug("Starting repository {}", (Object)repository.getName());
        RubygemsContentFacet facet = this.content(repository);
        Continuations.streamOf((arg_0, arg_1) -> ((FluentQuery)facet.assets().byKind(AssetKind.GEM_INFO.name())).browse(arg_0, arg_1)).peek(asset -> {
            boolean bl = CancelableHelper.checkCancellation();
        }).forEach(asset -> {
            FluentAttributes fluentAttributes = asset.attributes(AttributeOperation.OVERLAY, "rubygems", (Object)ImmutableMap.of((Object)"dirty_as_of", (Object)OffsetDateTime.now().toString()));
        });
    }

    private RubygemsContentFacet content(Repository repository) {
        return (RubygemsContentFacet)repository.facet(RubygemsContentFacet.class);
    }
}

