/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal.hosted;

import java.io.IOException;
import javax.inject.Named;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.datastore.RubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.marshal.GemSpecification;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;

@Named
@Facet.Exposed
public class RubygemsHostedFacet
extends FacetSupport {
    public Content putGem(RubygemsFile file, Payload payload) throws IOException {
        Content content;
        if (file.getCoordinate() == null) {
            content = this.content().putGem(payload);
        } else {
            GemCoordinate coordinate = file.getCoordinate();
            content = this.content().putGem(coordinate, payload);
        }
        GemSpecification gemspec = (GemSpecification)content.getAttributes().require(GemSpecification.class);
        this.content().putGemSpec(gemspec);
        this.content().addToSpecsIndex(gemspec.getCoordinate());
        this.content().addToBundlerApi(gemspec);
        return content;
    }

    private RubygemsContentFacet content() {
        return (RubygemsContentFacet)this.getRepository().facet(RubygemsContentFacet.class);
    }
}

