/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal.hosted;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.event.asset.AssetEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentDeletedEvent;
import org.sonatype.nexus.repository.content.store.ContentStoreEvent;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.datastore.RubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.internal.hosted.GemInfoHostedFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
public class GemInfoHostedFacetImpl
extends FacetSupport
implements GemInfoHostedFacet,
EventAware.Asynchronous {
    private static final String PREFIX = "---\n";
    private final Cooperation2Factory.Builder cooperationBuilder;
    private Cooperation2 cooperation;

    @Inject
    public GemInfoHostedFacetImpl(Cooperation2Factory cooperationFactory, @Named(value="${nexus.ruby.geminfo.cooperation.enabled:-true}") @Named(value="${nexus.ruby.geminfo.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.ruby.geminfo.cooperation.majorTimeout:-0s}") @Named(value="${nexus.ruby.geminfo.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.ruby.geminfo.cooperation.minorTimeout:-30s}") @Named(value="${nexus.ruby.geminfo.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.ruby.geminfo.cooperation.threadsPerKey:-100}") @Named(value="${nexus.ruby.geminfo.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        this.cooperationBuilder = ((Cooperation2Factory)Preconditions.checkNotNull((Object)cooperationFactory)).configure().enabled(cooperationEnabled).majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.cooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":geminfo");
    }

    @Override
    @Guarded(by={"STARTED"})
    public Optional<Content> get(String gemName) throws IOException {
        Optional<Content> result = this.content().gemInfo(gemName);
        if (result.isPresent()) {
            return result;
        }
        return Optional.ofNullable(this.rebuild(gemName));
    }

    @Override
    @Nullable
    public Content rebuild(String gemName) throws IOException {
        return (Content)this.cooperation.on(() -> this.doRebuild(gemName)).checkFunction(() -> this.content().gemInfo(gemName)).cooperate(gemName, new String[0]);
    }

    private Content doRebuild(String gemName) {
        OffsetDateTime start = OffsetDateTime.now();
        String versions = this.content().getGemsByName(gemName).map(this::createVersionLine).filter(Objects::nonNull).collect(Collectors.joining("\n", PREFIX, ""));
        if (PREFIX.length() == versions.length()) {
            this.log.debug("Built empty response for {} in {} attempting to remove existing asset", (Object)gemName, (Object)this.getRepository().getName());
            this.content().deleteGemInfo(gemName);
            return null;
        }
        try {
            return this.content().putGemInfo(gemName, (Payload)new StringPayload(versions, "text/plain"), start);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetEvent event) {
        if (this.isRelevant((ContentStoreEvent)event)) {
            Asset asset = event.getAsset();
            if (!AssetKind.GEM.toString().equals(asset.kind())) {
                return;
            }
            asset.component().map(Component::name).ifPresent(this.content()::markGemInfoForRebuild);
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(ComponentDeletedEvent event) {
        if (this.isRelevant((ContentStoreEvent)event)) {
            this.markForRebuild(event.getComponent().name());
        }
    }

    @Override
    public void markForRebuild(String gemName) {
        boolean otherVersions;
        boolean bl = otherVersions = !this.content().components().versions("", gemName).isEmpty();
        if (otherVersions) {
            this.log.debug("Marking {} in {} for rebuild", (Object)gemName, (Object)this.getRepository().getName());
            this.content().markGemInfoForRebuild(gemName);
        } else {
            this.log.debug("Deleting info/{} in {}", (Object)gemName, (Object)this.getRepository().getName());
            this.content().deleteGemInfo(gemName);
        }
    }

    @Nullable
    private String createVersionLine(Asset asset) {
        Component component = asset.component().orElse(null);
        if (component == null) {
            this.log.warn("Gem {} is missing component in {}", (Object)asset.path(), (Object)this.getRepository().getName());
            return null;
        }
        String checksum = asset.blob().map(AssetBlob::checksums).map(checksums -> (String)checksums.get(HashAlgorithm.SHA256.name())).orElse(null);
        if (checksum == null) {
            this.log.debug("Missing sha256 or blob for {} in {}", (Object)asset.path(), (Object)this.getRepository().getName());
            return null;
        }
        NestedAttributesMap rubyAttr = asset.attributes().child("rubygems");
        String platform = (String)rubyAttr.get("platform", String.class);
        String dependencies = (String)rubyAttr.get("dependencies", String.class);
        String requiredRubyVersion = (String)rubyAttr.get("required ruby version", String.class);
        String requiredRubygemsVersion = (String)rubyAttr.get("required rubygems version", String.class);
        if (dependencies == null) {
            this.log.warn("Skipping {} as the dependencies information is missing in {}", (Object)asset.path(), (Object)this.getRepository().getName());
            return null;
        }
        try {
            return this.createVersionLine(component.version(), platform, dependencies, checksum, requiredRubyVersion, requiredRubygemsVersion);
        }
        catch (IllegalArgumentException e) {
            this.log.warn("Could not parse version {} from gem {}", new Object[]{component.version(), asset.path(), this.log.isDebugEnabled() ? e : null});
            return null;
        }
    }

    private RubygemsContentFacet content() {
        return (RubygemsContentFacet)this.getRepository().facet(RubygemsContentFacet.class);
    }

    private boolean isRelevant(ContentStoreEvent event) {
        return event.getRepository().map(this.getRepository()::equals).orElse(false);
    }
}

