/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.joda.time.ReadableInstant;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.content.facet.ContentProxyFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.datastore.RubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.datastore.internal.BundlerContentApiUtils;
import org.sonatype.nexus.repository.rubygems.datastore.internal.GzipContentWrapper;
import org.sonatype.nexus.repository.rubygems.datastore.internal.RubygemsContentFacetImpl;
import org.sonatype.nexus.repository.rubygems.internal.BundlerGemsPayload;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerGem;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerGems;
import org.sonatype.nexus.repository.rubygems.marshal.Marshal;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="rubygems")
public class RubygemsProxyContentFacet
extends ContentProxyFacetSupport {
    protected Content getCachedContent(Context context) throws IOException {
        RubygemsFile file = this.getRubygemsFile(context);
        switch (file.getKind()) {
            case BUNDLER_API_DEPENDENCIES: {
                return this.getCachedBundlerGems(file);
            }
            case GEM_INFO: {
                return this.contentFacet().gemInfo(file.getGems().get(0)).orElse(null);
            }
            case SPECS_INDEX: {
                return this.contentFacet().get(file.getPath()).map(FluentAsset::download).map(GzipContentWrapper::new).orElse(null);
            }
            case VERSIONS: {
                return this.contentFacet().versions().orElse(null);
            }
        }
        return this.contentFacet().get(file.getPath()).map(FluentAsset::download).orElse(null);
    }

    protected Content doGet(Context context, @Nullable Content staleContent) throws IOException {
        RubygemsFile file = this.getRubygemsFile(context);
        if (AssetKind.BUNDLER_API_DEPENDENCIES.equals((Object)file.getKind())) {
            if (file.getGems() != null && file.getGems().isEmpty()) {
                return new Content((Payload)BundlerContentApiUtils.EMPTY_BUNDLER_GEMS_PAYLOAD);
            }
            if (file.getGems() == null) {
                return new Content((Payload)BundlerContentApiUtils.EMPTY_PAYLOAD);
            }
        }
        Content content = super.doGet(context, staleContent);
        this.log.trace("get {} for {}", (Object)content, (Object)file);
        return content;
    }

    protected String getUrl(Context context) {
        Preconditions.checkNotNull((Object)context);
        return this.getRubygemsFile(context).getUrl();
    }

    private Content getCachedBundlerGems(RubygemsFile file) throws IOException {
        if (file.getGems() == null) {
            return null;
        }
        BundlerGems result = new BundlerGems();
        CacheInfo info = null;
        ArrayList<FluentAsset> assets = new ArrayList<FluentAsset>();
        for (String gem : file.getGems()) {
            Optional<FluentAsset> asset = this.contentFacet().get(GemCoordinate.dependenciesPath(gem));
            if (!asset.isPresent()) {
                this.log.trace("no dependencies for '{}'", (Object)gem);
                return null;
            }
            this.log.trace("loaded dependencies {}", asset);
            FluentAsset fluentAsset = asset.get();
            Content contentPayload = fluentAsset.download();
            CacheInfo next = (CacheInfo)contentPayload.getAttributes().get(CacheInfo.class);
            if (info == null || next != null && next.getLastVerified().isBefore((ReadableInstant)info.getLastVerified())) {
                info = next;
            }
            assets.add(fluentAsset);
            BundlerGems oneGem = BundlerContentApiUtils.asBundlerGems((Payload)contentPayload);
            result.addAll(oneGem.getGems());
        }
        Content content = new Content((Payload)new BundlerGemsPayload(result));
        content.getAttributes().set("assetList", assets);
        content.getAttributes().set(CacheInfo.class, info);
        return content;
    }

    protected CacheController getCacheController(Context context) {
        Preconditions.checkNotNull((Object)context);
        RubygemsFile file = this.getRubygemsFile(context);
        return this.cacheControllerHolder.require(file.getKind().getCacheType());
    }

    protected Content store(Context context, Content content) throws IOException {
        RubygemsFile file = this.getRubygemsFile(context);
        this.log.trace("store {} for {}", (Object)content, (Object)file);
        return this.doStore(file, content);
    }

    private Content doStore(RubygemsFile file, Content content) throws IOException {
        switch (file.getKind()) {
            case GEM: {
                return this.contentFacet().putGem(file.getCoordinate(), (Payload)content);
            }
            case GEMSPEC: {
                return this.contentFacet().putGemSpec((Payload)content);
            }
            case SPECS_INDEX: {
                return this.storeSpecIndex(file, content);
            }
            case BUNDLER_API_DEPENDENCIES: {
                return this.handleBundlerDependencies(content);
            }
            case GEM_INFO: {
                return this.contentFacet().putGemInfo(file.getPath(), (Payload)content);
            }
            case VERSIONS: {
                return this.contentFacet().putVersions((Payload)content);
            }
        }
        throw new IllegalStateException("Received an invalid AssetKind of type: " + (Object)((Object)file.getKind()));
    }

    private Content storeSpecIndex(RubygemsFile file, Content content) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = this.contentFacet().ingest((Payload)content);){
            return new GzipContentWrapper(this.contentFacet().getSpecsIndexAsset(file, tempBlob).attach(tempBlob).markAsCached((Payload)content).download());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content handleBundlerDependencies(Content content) throws IOException {
        BundlerGems gems;
        Throwable throwable = null;
        Object var4_4 = null;
        try (InputStream is = content.openInputStream();){
            gems = Marshal.loadAs(is, BundlerGems.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        LinkedHashMap<String, BundlerGems> map = new LinkedHashMap<String, BundlerGems>();
        for (BundlerGem gem : gems.getGems()) {
            BundlerGems entry = (BundlerGems)map.get(gem.getName());
            if (entry == null) {
                entry = new BundlerGems();
                map.put(gem.getName(), entry);
            }
            entry.add(gem);
        }
        ArrayList<FluentAsset> assets = new ArrayList<FluentAsset>();
        for (Map.Entry entry : map.entrySet()) {
            this.log.trace("store dependencies {}", entry.getValue());
            FluentAsset gemAsset = this.contentFacet().getBundlerGemAsset(GemCoordinate.dependenciesPath((String)entry.getKey()));
            byte[] gemContent = Marshal.dumpAsBytes(entry.getValue());
            this.updateAsset(gemAsset, new ByteArrayInputStream(gemContent));
            gemAsset.markAsCached((Payload)content);
            assets.add(gemAsset);
        }
        Content result = new Content((Payload)new BundlerGemsPayload(gems));
        result.getAttributes().set("assetList", assets);
        return result;
    }

    private RubygemsFile getRubygemsFile(Context context) {
        Preconditions.checkNotNull((Object)context);
        return (RubygemsFile)((Object)context.getAttributes().require(RubygemsFile.class));
    }

    private RubygemsContentFacet contentFacet() {
        return (RubygemsContentFacet)this.getRepository().facet(RubygemsContentFacet.class);
    }

    private void updateAsset(FluentAsset asset, InputStream stream) {
        Preconditions.checkNotNull((Object)asset);
        Preconditions.checkNotNull((Object)stream);
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob blob = this.contentFacet().blobs().ingest(stream, "application/octet-stream", RubygemsContentFacetImpl.HASH_ALGORITHMS);){
            asset.attach(blob);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

