/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal;

import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.content.search.SearchFacet;
import org.sonatype.nexus.repository.http.HttpHandlers;
import org.sonatype.nexus.repository.http.PartialFetchHandler;
import org.sonatype.nexus.repository.recipe.RouterBuilder;
import org.sonatype.nexus.repository.rubygems.datastore.internal.RubygemsComponentMaintenanceImpl;
import org.sonatype.nexus.repository.rubygems.datastore.internal.RubygemsContentHandler;
import org.sonatype.nexus.repository.rubygems.datastore.internal.RubygemsLastDownloadedHandler;
import org.sonatype.nexus.repository.rubygems.datastore.internal.RubygemsRecipeSupport;
import org.sonatype.nexus.repository.rubygems.datastore.internal.hosted.RubygemsHostedFacet;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsFileMatcher;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsPaths;
import org.sonatype.nexus.repository.rubygems.internal.hosted.GemInfoHostedFacet;
import org.sonatype.nexus.repository.rubygems.internal.hosted.HostedGemInfoHandler;
import org.sonatype.nexus.repository.rubygems.internal.hosted.VersionsHostedFacet;
import org.sonatype.nexus.repository.rubygems.internal.hosted.VersionsHostedHandler;
import org.sonatype.nexus.repository.view.ConfigurableViewFacet;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.ViewFacet;

@AvailabilityVersion(from="1.0")
@Named(value="rubygems-hosted")
@Singleton
public class RubygemsHostedRecipe
extends RubygemsRecipeSupport {
    public static final String NAME = "rubygems-hosted";
    @Inject
    Provider<RubygemsHostedFacet> rubygemsHostedFacet;
    @Inject
    @Named(value="rubygems")
    Provider<RubygemsComponentMaintenanceImpl> componentMaintenance;
    @Inject
    Provider<SearchFacet> searchFacet;
    @Inject
    Provider<GemInfoHostedFacet> gemInfoHostedFacet;
    @Inject
    Provider<VersionsHostedFacet> versionsHostedFacet;
    @Inject
    PartialFetchHandler partialFetchHandler;
    @Inject
    RubygemsContentHandler rubygemsContentHandler;
    @Inject
    RubygemsLastDownloadedHandler lastDownloadedHandler;

    @Inject
    public RubygemsHostedRecipe(@Named(value="hosted") @Named(value="hosted") Type type, @Named(value="rubygems") @Named(value="rubygems") Format format) {
        super(type, format);
    }

    public void apply(@Nonnull Repository repository) throws Exception {
        repository.attach((Facet)this.securityFacet.get());
        repository.attach((Facet)this.configure((ConfigurableViewFacet)this.viewFacet.get()));
        repository.attach((Facet)this.contentFacet.get());
        repository.attach((Facet)this.componentMaintenance.get());
        repository.attach((Facet)this.browseFacet.get());
        repository.attach((Facet)this.searchFacet.get());
        repository.attach((Facet)this.gemInfoHostedFacet.get());
        repository.attach((Facet)this.versionsHostedFacet.get());
        repository.attach((Facet)this.rubygemsHostedFacet.get());
    }

    private ViewFacet configure(ConfigurableViewFacet facet) {
        Router.Builder builder = new Router.Builder();
        this.addBrowseUnsupportedRoute((RouterBuilder)builder);
        builder.route(this.addHandlers(RubygemsPaths.gemInfoMatcher()).handler((Handler)new HostedGemInfoHandler()).create());
        builder.route(this.addHandlers(RubygemsPaths.versionsMatcher()).handler((Handler)new VersionsHostedHandler()).create());
        builder.route(new Route.Builder().matcher((Matcher)new RubygemsFileMatcher()).handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.handlerContributor).handler((Handler)this.partialFetchHandler).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.contentHeadersHandler).handler((Handler)this.lastDownloadedHandler).handler((Handler)this.rubygemsContentHandler).create());
        builder.defaultHandlers(new Handler[]{HttpHandlers.badRequest()});
        facet.configure(builder.create());
        return facet;
    }

    private Route.Builder addHandlers(Route.Builder builder) {
        return builder.handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.handlerContributor).handler((Handler)this.partialFetchHandler).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.contentHeadersHandler).handler((Handler)this.rubyBundlerEtagHandler).handler((Handler)this.lastDownloadedHandler);
    }
}

