/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.UpgradeTaskScheduler;
import org.sonatype.nexus.upgrade.datastore.RepeatableDatabaseMigrationStep;

@Named
@Singleton
public class RubygemsHashAndAttributesMigrationStep
extends RepeatableDatabaseMigrationStep {
    private static final String SELECT_RUBY_REPOSITORIES = "SELECT name FROM repository WHERE recipe_name = 'rubygems-hosted' OR recipe_name = 'rubygems-proxy'";
    private final UpgradeTaskScheduler scheduler;
    private final TaskScheduler taskScheduler;

    @Inject
    public RubygemsHashAndAttributesMigrationStep(UpgradeTaskScheduler scheduler, TaskScheduler taskScheduler) {
        this.scheduler = (UpgradeTaskScheduler)Preconditions.checkNotNull((Object)scheduler);
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    public void migrate(Connection connection) throws Exception {
        this.log.info("Updating gem attributes and generating sha256 checksums for ruby");
        String rubyRepositoryNames = this.rubyRepositories(connection).stream().collect(Collectors.joining(","));
        this.log.debug("Found the following ruby repositories: {}", (Object)rubyRepositoryNames);
        if (Strings2.isBlank((String)rubyRepositoryNames)) {
            return;
        }
        this.scheduleAttributeUpdate(rubyRepositoryNames);
        this.scheduleSha256(rubyRepositoryNames);
    }

    private void scheduleAttributeUpdate(String repositoryName) {
        TaskConfiguration conf = this.createConfiguration("repository.ruby.rebuild.attributes", repositoryName);
        conf.setName("Updating gem attributes for " + repositoryName);
        this.scheduler.schedule(conf);
    }

    private void scheduleSha256(String repositoryName) {
        TaskConfiguration conf = this.createConfiguration("repository.rubygems.generate-sha256-checksums", repositoryName);
        conf.setName("Generating sha256 checksums for " + repositoryName);
        this.scheduler.schedule(conf);
    }

    private TaskConfiguration createConfiguration(String typeId, String repositoryName) {
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance(typeId);
        configuration.setString("repositoryName", repositoryName);
        return configuration;
    }

    /*
     * Loose catch block
     */
    private Collection<String> rubyRepositories(Connection connection) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            ArrayList<String> arrayList;
            ResultSet set;
            PreparedStatement statement;
            block17: {
                block16: {
                    statement = connection.prepareStatement(SELECT_RUBY_REPOSITORIES);
                    set = statement.executeQuery();
                    ArrayList<String> repositoryNames = new ArrayList<String>();
                    while (set.next()) {
                        repositoryNames.add(set.getString("name"));
                    }
                    arrayList = repositoryNames;
                    if (set == null) break block16;
                    set.close();
                }
                if (statement == null) break block17;
                statement.close();
            }
            return arrayList;
            {
                catch (Throwable throwable2) {
                    try {
                        if (set != null) {
                            set.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public Integer getChecksum() {
        return 1;
    }
}

