/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashCode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssetBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.datastore.RubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.datastore.internal.BundlerContentApiUtils;
import org.sonatype.nexus.repository.rubygems.datastore.internal.GemCoordinateUtils;
import org.sonatype.nexus.repository.rubygems.internal.BundlerGemsPayload;
import org.sonatype.nexus.repository.rubygems.internal.GZippedTempStreamSupplier;
import org.sonatype.nexus.repository.rubygems.internal.utils.GemSpecificationUtils;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerGem;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerGems;
import org.sonatype.nexus.repository.rubygems.marshal.GemSpecification;
import org.sonatype.nexus.repository.rubygems.marshal.Marshal;
import org.sonatype.nexus.repository.rubygems.marshal.SpecsIndex;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="rubygems")
public class RubygemsContentFacetImpl
extends ContentFacetSupport
implements RubygemsContentFacet {
    private static final Set<String> REWRITEABLE_KINDS = ImmutableSet.of((Object)AssetKind.BUNDLER_API_DEPENDENCIES.name(), (Object)AssetKind.GEM_INFO.name(), (Object)AssetKind.SPECS_INDEX.name(), (Object)AssetKind.VERSIONS.name());
    public static final List<HashAlgorithm> HASH_ALGORITHMS = Collections.unmodifiableList(Arrays.asList(HashAlgorithm.MD5, HashAlgorithm.SHA1, HashAlgorithm.SHA256));
    private static final String DIRTY_TIME_KEY = "dirty_as_of";
    private static final String BUILT_TIME_KEY = "built_at";

    @Inject
    protected RubygemsContentFacetImpl(@Named(value="rubygems") @Named(value="rubygems") FormatStoreManager formatStoreManager) {
        super(formatStoreManager);
    }

    @Override
    public TempBlob ingest(Payload payload) throws IOException {
        return this.blobs().ingest(payload, HASH_ALGORITHMS);
    }

    @Override
    public TempBlob ingest(InputStreamSupplier streamSupplier) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = streamSupplier.get();){
            return this.blobs().ingest(inputStream, "application/octet-stream", HASH_ALGORITHMS);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content putGem(Payload payload) throws IOException {
        return this.putGem(Optional.empty(), payload);
    }

    @Override
    public Content putGem(GemCoordinate expectedCoordinate, Payload payload) throws IOException {
        return this.putGem(Optional.of(expectedCoordinate), payload);
    }

    private Content putGem(Optional<GemCoordinate> optCoordinate, Payload payload) throws IOException {
        this.log.trace("put gem {}", optCoordinate);
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = this.ingest(payload);){
            GemSpecification gemspec = GemSpecificationUtils.retrieveGemSpecification((InputStreamSupplier)tempBlob);
            if (optCoordinate.isPresent() && !optCoordinate.get().equals(gemspec.getCoordinate())) {
                throw new IllegalArgumentException("filename and gemname from gem do not match");
            }
            GemCoordinate coordinate = (GemCoordinate)Preconditions.checkNotNull((Object)optCoordinate.orElseGet(gemspec::getCoordinate));
            FluentComponent component = this.getOrCreateGemComponent(coordinate);
            Content content = this.updateOrCreateGemAsset(component, gemspec, tempBlob).markAsCached(payload).download();
            content.getAttributes().set(GemSpecification.class, (Object)gemspec);
            return content;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Content putGemSpec(Payload payload) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Content content;
            InflaterInputStream in;
            TempBlob blob;
            block16: {
                block15: {
                    blob = this.ingest(payload);
                    in = new InflaterInputStream(blob.get());
                    GemSpecification gemspec = Marshal.loadAs(in, GemSpecification.class);
                    content = this.putGemSpec(gemspec.getCoordinate(), blob).markAsCached(payload).download();
                    if (in == null) break block15;
                    ((InputStream)in).close();
                }
                if (blob == null) break block16;
                blob.close();
            }
            return content;
            {
                catch (Throwable throwable2) {
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (blob != null) {
                            blob.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public Content putGemSpec(GemSpecification gemspec) throws IOException {
        byte[] bytes = Marshal.dumpAsBytes(gemspec);
        StreamPayload payload = new StreamPayload(() -> new DeflaterInputStream(new ByteArrayInputStream(bytes)), (long)bytes.length, "application/octet-stream");
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob blob = this.ingest((Payload)payload);){
            return this.putGemSpec(gemspec.getCoordinate(), blob).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private FluentAsset putGemSpec(GemCoordinate coordinate, TempBlob blob) throws IOException {
        return this.assets().path(RubygemsContentFacetImpl.assetPath(coordinate.gemspecPath())).component((Component)this.getOrCreateGemComponent(coordinate)).attributes("rubygems", (Object)ImmutableMap.of((Object)"platform", (Object)coordinate.getPlatform())).blob(blob).save();
    }

    @Override
    public FluentAsset putGemWithHardlink(GemSpecification specification, Blob assetBlob, Map<HashAlgorithm, HashCode> checksums) throws IOException {
        GemCoordinate coordinate = Objects.requireNonNull(specification.getCoordinate());
        FluentComponent component = this.getOrCreateGemComponent(coordinate);
        this.addToSpecsIndex(coordinate);
        this.addToBundlerApi(specification);
        this.updateGemspec(component, specification);
        return this.updateOrCreateGemAssetWithHardlink(component, specification, assetBlob, checksums);
    }

    @Override
    public Content getBundlerApiDependencies(List<String> gems) throws IOException {
        Objects.requireNonNull(gems);
        BundlerGems result = new BundlerGems();
        ArrayList<FluentAsset> assets = new ArrayList<FluentAsset>();
        for (String gem : gems) {
            this.log.trace("load dependencies for {}", (Object)gem);
            Optional<FluentAsset> asset = this.findBundlerApiDependencies(gem);
            if (!asset.isPresent()) continue;
            BundlerGems oneGem = BundlerContentApiUtils.asBundlerGems(asset.get());
            result.addAll(oneGem.getGems());
            assets.add(asset.get());
        }
        Content content = new Content((Payload)new BundlerGemsPayload(result));
        content.getAttributes().set("assetList", assets);
        return content;
    }

    @Override
    public Set<String> deleteGem(String assetPath) throws IOException {
        Optional<FluentAsset> rubygemsAsset = this.get(assetPath);
        if (!rubygemsAsset.isPresent()) {
            return Collections.emptySet();
        }
        FluentAsset asset = rubygemsAsset.get();
        if (!asset.kind().equals(AssetKind.GEM.name())) {
            this.log.trace("Did not delete: {}", (Object)asset);
            return Collections.emptySet();
        }
        Optional component = asset.component();
        if (component.isPresent()) {
            GemCoordinate coordinate = GemCoordinateUtils.toGemCoordinate((Component)component.get(), asset);
            this.deleteFromSpecsIndex(coordinate);
            this.deleteFromBundlerApi(coordinate);
            ImmutableSet.Builder deletedPaths = ImmutableSet.builder();
            FluentComponent componentToDelete = this.components().with((Component)component.get());
            componentToDelete.assets().forEach(assetToDelete -> {
                if (assetToDelete.delete()) {
                    deletedPaths.add((Object)assetToDelete.path());
                }
            });
            componentToDelete.delete();
            return deletedPaths.build();
        }
        return Collections.emptySet();
    }

    @Override
    public Optional<FluentAsset> get(String path) {
        return this.assets().path(RubygemsContentFacetImpl.assetPath(path)).find();
    }

    @Override
    public FluentAsset restoreAsset(String path, AssetKind assetKind, Payload payload) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, HASH_ALGORITHMS);){
            Optional fluentAsset = this.assets().path(RubygemsContentFacetImpl.assetPath(path)).find();
            return fluentAsset.orElseGet(() -> this.assets().path(path).kind(assetKind.name()).blob(tempBlob).save());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Optional<FluentAsset> findBundlerApiDependencies(String name) {
        return this.get(GemCoordinate.dependenciesPath(name));
    }

    @Override
    public FluentAsset getCachedOrNewSpecsIndex(String path) throws IOException {
        Optional<FluentAsset> cachedSpecsIndex = this.get(path);
        if (cachedSpecsIndex.isPresent()) {
            return cachedSpecsIndex.get();
        }
        FluentAsset asset = this.createAsset(RubygemsContentFacetImpl.assetPath(path), AssetKind.SPECS_INDEX.name());
        return this.updateSpecsIndex(asset, new SpecsIndex());
    }

    private FluentAsset updateOrCreateGemAsset(FluentComponent component, GemSpecification gemSpecification, TempBlob tempBlob) {
        return this.prepareGemFluentAsset(component, gemSpecification).blob(tempBlob).save();
    }

    @Override
    public FluentAsset updateOrCreateGemAssetWithHardlink(FluentComponent component, GemSpecification gemSpecification, Blob blob, Map<HashAlgorithm, HashCode> checksums) {
        return this.prepareGemFluentAsset(component, gemSpecification).blob(blob, checksums).save();
    }

    private FluentAssetBuilder prepareGemFluentAsset(FluentComponent component, GemSpecification gemSpecification) {
        GemCoordinate coordinate = Objects.requireNonNull(gemSpecification.getCoordinate());
        String path = RubygemsContentFacetImpl.assetPath(coordinate.gemPath());
        return this.assets().path(path).kind(AssetKind.GEM.name()).component((Component)component).attributes("rubygems", GemSpecificationUtils.getGemSpecificationAttributes(gemSpecification));
    }

    private FluentComponent getOrCreateGemComponent(GemCoordinate coordinate) {
        Preconditions.checkNotNull((Object)coordinate);
        return this.components().name(coordinate.getName()).version(coordinate.getVersion()).normalizedVersion(this.versionNormalizerService().getNormalizedVersionByFormat(coordinate.getVersion(), this.repository().getFormat())).getOrCreate();
    }

    private FluentAsset getOrCreateGemspecAsset(FluentComponent component, GemCoordinate coordinate) {
        String gemspecName = coordinate.gemspecPath();
        Optional<FluentAsset> getGemAsset = this.get(gemspecName);
        if (!getGemAsset.isPresent()) {
            FluentAsset asset = this.createAsset(RubygemsContentFacetImpl.assetPath(gemspecName), AssetKind.GEMSPEC.name(), component);
            this.log.trace("Created asset: {}", (Object)gemspecName);
            HashMap<String, String> formatAttributes = new HashMap<String, String>();
            formatAttributes.put("platform", coordinate.getPlatform());
            asset.withAttribute("rubygems", formatAttributes);
            return asset;
        }
        return getGemAsset.get();
    }

    @Override
    public FluentAsset getBundlerGemAsset(String path) {
        Optional<FluentAsset> asset = this.get(RubygemsContentFacetImpl.assetPath(path));
        return asset.orElseGet(() -> this.assets().path(RubygemsContentFacetImpl.assetPath(path)).kind(AssetKind.BUNDLER_API_DEPENDENCIES.name()).save());
    }

    @Override
    public FluentAsset getSpecsIndexAsset(RubygemsFile file, TempBlob tempBlob) {
        String assetPath = RubygemsContentFacetImpl.assetPath(file.getPath());
        Optional<FluentAsset> asset = this.get(assetPath);
        return asset.orElseGet(() -> this.assets().path(assetPath).kind(AssetKind.SPECS_INDEX.name()).blob(tempBlob).save());
    }

    protected WritePolicy writePolicy(Asset asset) {
        String assetKind;
        WritePolicy writePolicy = super.writePolicy(asset);
        if (writePolicy == WritePolicy.ALLOW_ONCE && REWRITEABLE_KINDS.contains(assetKind = asset.kind())) {
            return WritePolicy.ALLOW;
        }
        return writePolicy;
    }

    private FluentAsset createAsset(String path, String assetKind) {
        return this.assets().path(path).kind(assetKind).save();
    }

    private FluentAsset createAsset(String path, String assetKind, FluentComponent component) {
        FluentAssetBuilder assetBuilder = this.assets().path(path).kind(assetKind).component((Component)component);
        return assetBuilder.save();
    }

    private FluentAsset updateAsset(FluentAsset asset, Payload payload) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, HASH_ALGORITHMS);){
            return asset.attach(tempBlob);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void addToSpecsIndex(GemCoordinate coordinate) throws IOException {
        this.log.trace("Adding {} to specs-index", (Object)coordinate);
        String path = coordinate.isPrereleaseGem() ? RubygemsFile.PRERELEASE_SPECS_4_8_GZ : RubygemsFile.SPECS_4_8_GZ;
        FluentAsset asset = this.get(path).orElseGet(() -> this.createAsset(RubygemsContentFacetImpl.assetPath(path), AssetKind.SPECS_INDEX.name()));
        SpecsIndex index = RubygemsContentFacetImpl.asSpecsIndex(asset);
        index.add(coordinate);
        this.updateSpecsIndex(asset, index);
        if (!coordinate.isPrereleaseGem()) {
            this.updateLatestSpecsIndex(index);
        }
    }

    private void deleteFromSpecsIndex(GemCoordinate coordinate) throws IOException {
        this.log.trace("Deleting {} to specs-index", (Object)coordinate);
        String path = coordinate.isPrereleaseGem() ? RubygemsFile.PRERELEASE_SPECS_4_8_GZ : RubygemsFile.SPECS_4_8_GZ;
        Optional<FluentAsset> specIndex = this.get(path);
        if (specIndex.isPresent()) {
            FluentAsset asset = specIndex.get();
            SpecsIndex index = RubygemsContentFacetImpl.asSpecsIndex(asset);
            index.remove(coordinate);
            this.updateSpecsIndex(asset, index);
            if (!coordinate.isPrereleaseGem()) {
                this.updateLatestSpecsIndex(index);
            }
        }
    }

    private FluentAsset updateSpecsIndex(FluentAsset specs, SpecsIndex index) throws IOException {
        InputStream inputStream = Marshal.dumpAsInputStream(index);
        Throwable throwable = null;
        Object var5_6 = null;
        try (GZippedTempStreamSupplier streamSupplier = new GZippedTempStreamSupplier(inputStream);){
            return this.updateAsset(specs, (Payload)new StreamPayload((InputStreamSupplier)streamSupplier, (long)inputStream.available(), "application/octet-stream"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void deleteFromBundlerApi(GemCoordinate coordinate) throws IOException {
        FluentAsset asset = this.getBundlerApiDependencies(coordinate.getName());
        BundlerGems gems = BundlerContentApiUtils.asBundlerGems(asset);
        gems.remove(new BundlerGem(coordinate));
        this.updateBundlerGems(asset, gems);
    }

    private static SpecsIndex asSpecsIndex(FluentAsset asset) throws IOException {
        if (!asset.hasBlob()) {
            return new SpecsIndex();
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (GZIPInputStream is = new GZIPInputStream(asset.download().openInputStream());){
            return Marshal.loadAs(is, SpecsIndex.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateLatestSpecsIndex(SpecsIndex index) throws IOException {
        Optional<FluentAsset> latest = this.get(RubygemsContentFacetImpl.assetPath(RubygemsFile.LATEST_SPECS_4_8_GZ));
        FluentAsset asset = latest.isPresent() ? latest.get() : this.createAsset(RubygemsContentFacetImpl.assetPath(RubygemsFile.LATEST_SPECS_4_8_GZ), AssetKind.SPECS_INDEX.name());
        this.updateSpecsIndex(asset, index.toLatest());
    }

    @Override
    public void addToBundlerApi(GemSpecification gemspec) throws IOException {
        FluentAsset asset = this.getBundlerApiDependencies(gemspec.getName());
        BundlerGems gems = BundlerContentApiUtils.asBundlerGems(asset);
        gems.add(new BundlerGem(gemspec));
        this.updateBundlerGems(asset, gems);
    }

    private void updateGemspec(FluentComponent component, GemSpecification gemspec) throws IOException {
        FluentAsset asset = this.getOrCreateGemspecAsset(component, Objects.requireNonNull(gemspec.getCoordinate()));
        byte[] bytes = Marshal.dumpAsBytes(gemspec);
        this.updateAsset(asset, (Payload)new StreamPayload(() -> new DeflaterInputStream(new ByteArrayInputStream(bytes)), (long)bytes.length, "application/octet-stream"));
    }

    private FluentAsset getBundlerApiDependencies(String name) {
        Optional<FluentAsset> asset = this.findBundlerApiDependencies(name);
        if (asset.isPresent()) {
            return asset.get();
        }
        return this.createAsset(RubygemsContentFacetImpl.assetPath(GemCoordinate.dependenciesPath(name)), AssetKind.BUNDLER_API_DEPENDENCIES.name());
    }

    private void updateBundlerGems(FluentAsset asset, BundlerGems gems) throws IOException {
        if (gems.getGems().isEmpty()) {
            asset.delete();
        } else {
            byte[] bytes = Marshal.dumpAsBytes(gems);
            this.updateAsset(asset, (Payload)new StreamPayload(() -> new ByteArrayInputStream(bytes), (long)bytes.length, "application/octet-stream"));
        }
    }

    private static String assetPath(String assetPath) {
        return StringUtils.prependIfMissing((String)assetPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    @Override
    public Content putVersions(Payload content) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TempBlob blob = this.ingest(content);){
            return this.assets().path("/versions").kind(AssetKind.VERSIONS.name()).blob(blob).save().markAsCached(content).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content putVersions(Payload content, OffsetDateTime built) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob blob = this.ingest(content);){
            ImmutableMap attributes = ImmutableMap.of((Object)BUILT_TIME_KEY, (Object)built.toString());
            FluentAsset asset = this.assets().path("/versions").kind(AssetKind.VERSIONS.name()).attributes("rubygems", (Object)attributes).blob(blob).save();
            if (asset.attributes().contains("rubygems")) {
                asset.attributes(AttributeOperation.OVERLAY, "rubygems", (Object)attributes);
            }
            return asset.markAsCached(content).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Optional<Content> versions() {
        return this.assets().path("/versions").find().map(FluentAsset::download);
    }

    @Override
    public Content putGemInfo(String gemName, Payload content) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob blob = this.ingest(content);){
            return this.assets().path(RubygemsContentFacetImpl.gemInfoPath(gemName)).kind(AssetKind.GEM_INFO.name()).blob(blob).save().markAsCached(content).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content putGemInfo(String gemName, Payload content, OffsetDateTime rebuiltTime) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob blob = this.ingest(content);){
            ImmutableMap attributes = ImmutableMap.of((Object)BUILT_TIME_KEY, (Object)rebuiltTime.toString());
            FluentAsset asset = this.assets().path(RubygemsContentFacetImpl.gemInfoPath(gemName)).kind(AssetKind.GEM_INFO.name()).attributes("rubygems", (Object)attributes).blob(blob).save();
            if (asset.attributes().contains("rubygems")) {
                asset.attributes(AttributeOperation.OVERLAY, "rubygems", (Object)attributes);
            }
            return asset.markAsCached(content).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean deleteGemInfo(String gemName) {
        return this.assets().path(RubygemsContentFacetImpl.gemInfoPath(gemName)).find().map(FluentAsset::delete).orElse(false);
    }

    @Override
    public Optional<Content> gemInfo(String gemName) {
        return this.assets().path(RubygemsContentFacetImpl.gemInfoPath(gemName)).find().filter(((Predicate<FluentAsset>)this::isDirty).negate()).map(FluentAsset::download);
    }

    @Override
    public void markGemInfoForRebuild(String gemName) {
        this.assets().path(RubygemsContentFacetImpl.gemInfoPath(gemName)).find().ifPresent(asset -> {
            this.log.debug("Marking for rebuild {} in {}", (Object)gemName, (Object)this.getRepository().getName());
            asset.attributes(AttributeOperation.OVERLAY, "rubygems", (Object)ImmutableMap.of((Object)DIRTY_TIME_KEY, (Object)OffsetDateTime.now().toString()));
        });
    }

    @Override
    public Stream<Asset> getGemsByName(String gemName) {
        String path = String.valueOf('/') + GemCoordinate.GEM_BASE_PATH + '/' + gemName;
        return Continuations.streamOf((arg_0, arg_1) -> ((FluentQuery)this.assets().byFilter("A.kind = #{filterParams.kind} AND path LIKE #{filterParams.path} AND c.name = #{filterParams.comp_name}", (Map)ImmutableMap.of((Object)"kind", (Object)AssetKind.GEM.name(), (Object)"path", (Object)(String.valueOf(path) + '%'), (Object)"comp_name", (Object)gemName))).browse(arg_0, arg_1)).map(Asset.class::cast);
    }

    private boolean isDirty(Asset asset) {
        Optional<OffsetDateTime> rebuilt = Optional.ofNullable((String)asset.attributes("rubygems").get(BUILT_TIME_KEY, String.class)).map(OffsetDateTime::parse);
        if (!rebuilt.isPresent()) {
            return false;
        }
        Optional<OffsetDateTime> dirty = Optional.ofNullable((String)asset.attributes("rubygems").get(DIRTY_TIME_KEY, String.class)).map(OffsetDateTime::parse);
        if (!dirty.isPresent()) {
            return false;
        }
        return dirty.get().isAfter(rebuilt.get());
    }

    private static String gemInfoPath(String gemName) {
        return "/info/" + gemName;
    }

    @Override
    public void markVersionsForRebuild() {
        this.assets().path("/versions").find().ifPresent(asset -> {
            this.log.debug("Marking versions for rebuild in {}", (Object)this.getRepository().getName());
            asset.attributes(AttributeOperation.OVERLAY, "rubygems", (Object)ImmutableMap.of((Object)DIRTY_TIME_KEY, (Object)OffsetDateTime.now().toString()));
        });
    }

    @Override
    public boolean isVersionsDirty() {
        return this.assets().path("/versions").find().map(this::isDirty).orElse(true);
    }
}

