/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal;

import java.util.Optional;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;

@Named
public class RubyBundlerEtagHandler
extends ComponentSupport
implements Handler {
    public Response handle(Context context) throws Exception {
        Response response = context.proceed();
        if (response.getStatus().getCode() != 200) {
            return response;
        }
        Payload payload = response.getPayload();
        if (payload instanceof Content) {
            Content content = (Content)payload;
            Optional.ofNullable((Asset)content.getAttributes().get(Asset.class)).flatMap(Asset::blob).map(AssetBlob::checksums).map(checksums -> (String)checksums.get(HashAlgorithm.MD5.name())).ifPresent(md5 -> {
                Object object = content.getAttributes().set("etag", md5);
            });
        } else {
            this.log.debug("Result is not an instance of Payload for {}", (Object)context);
        }
        return response;
    }
}

