/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.HashAlgorithmHelper;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.utils.HardLinkHelper;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.datastore.RubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.datastore.internal.RubygemsContentFacetImpl;
import org.sonatype.nexus.repository.rubygems.datastore.internal.hosted.RubygemsHostedFacet;
import org.sonatype.nexus.repository.rubygems.internal.utils.GemSpecificationUtils;
import org.sonatype.nexus.repository.rubygems.marshal.GemSpecification;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.PathPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlobPayload;

@Named(value="rubygems")
@Singleton
public class RubygemsUploadHandler
extends UploadHandlerSupport {
    private UploadDefinition definition;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapter variableResolverAdapter;
    private final HardLinkHelper hardLinkHelper;
    private final HashAlgorithmHelper hashAlgorithmHelper;

    @Inject
    public RubygemsUploadHandler(ContentPermissionChecker contentPermissionChecker, @Named(value="simple") @Named(value="simple") VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions, HardLinkHelper hardLinkHelper, HashAlgorithmHelper hashAlgorithmHelper) {
        super(uploadDefinitionExtensions);
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        this.variableResolverAdapter = (VariableResolverAdapter)Preconditions.checkNotNull((Object)variableResolverAdapter);
        this.hardLinkHelper = (HardLinkHelper)Preconditions.checkNotNull((Object)hardLinkHelper);
        this.hashAlgorithmHelper = (HashAlgorithmHelper)Preconditions.checkNotNull((Object)hashAlgorithmHelper);
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        RubygemsContentFacet contentFacet = (RubygemsContentFacet)repository.facet(RubygemsContentFacet.class);
        PartPayload payload = ((AssetUpload)upload.getAssetUploads().get(0)).getPayload();
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = contentFacet.ingest((Payload)payload);){
            GemSpecification gemSpecification = GemSpecificationUtils.retrieveGemSpecification((InputStreamSupplier)tempBlob);
            GemCoordinate coordinates = gemSpecification.getCoordinate();
            Preconditions.checkNotNull((Object)coordinates, (Object)"GemCoordinate is required for the upload operation");
            String path = StringUtils.prependIfMissing((String)coordinates.gemPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            this.ensurePermitted(repository.getName(), "rubygems", path, this.coordinatesToMap(coordinates));
            Content content = contentFacet.putGem((Payload)new TempBlobPayload(tempBlob));
            GemSpecification gemspec = (GemSpecification)content.getAttributes().require(GemSpecification.class);
            contentFacet.putGemSpec(gemspec);
            return new UploadResponse(Collections.singletonList(content), Collections.singletonList(((Asset)content.getAttributes().get(Asset.class)).path()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Content handle(Repository repository, File file, String path) throws IOException {
        return this.handle(new ImportFileConfiguration(repository, file, path));
    }

    public Content handle(ImportFileConfiguration configuration) throws IOException {
        String filename = configuration.getFile().getName();
        if (!filename.endsWith(RubygemsFile.GEM_SUFFIX)) {
            this.log.trace("Skipping {} as we only care about gem files.", (Object)filename);
            return null;
        }
        if (configuration.isHardLinkingEnabled()) {
            return this.handleHardLinkImport(configuration);
        }
        return this.handleImport(configuration);
    }

    private Content handleHardLinkImport(ImportFileConfiguration configuration) throws IOException {
        Repository repository = configuration.getRepository();
        File file = configuration.getFile();
        RubygemsContentFacet contentFacet = (RubygemsContentFacet)repository.facet(RubygemsContentFacet.class);
        Map checksums = this.hashAlgorithmHelper.calculateChecksums(file, RubygemsContentFacetImpl.HASH_ALGORITHMS);
        HashCode hashCodeSha1 = (HashCode)checksums.get(HashAlgorithm.SHA1);
        Blob blob = this.hardLinkHelper.ingestHardLink(repository, file, hashCodeSha1);
        GemSpecification gemSpecification = GemSpecificationUtils.retrieveGemSpecification(() -> blob.getInputStream());
        GemCoordinate coordinates = gemSpecification.getCoordinate();
        String path = StringUtils.prependIfMissing((String)coordinates.gemPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        this.ensurePermitted(repository.getName(), "rubygems", path, this.coordinatesToMap(coordinates));
        FluentAsset fluentAsset = contentFacet.putGemWithHardlink(gemSpecification, blob, checksums);
        return fluentAsset.download();
    }

    /*
     * Loose catch block
     */
    private Content handleImport(ImportFileConfiguration configuration) throws IOException {
        Repository repository = configuration.getRepository();
        File file = configuration.getFile();
        Path contentPath = file.toPath();
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            Content content;
            TempBlob tempBlob;
            PathPayload payload;
            block16: {
                block15: {
                    payload = new PathPayload(contentPath, Files.probeContentType(contentPath));
                    tempBlob = ((RubygemsContentFacet)repository.facet(RubygemsContentFacet.class)).ingest((Payload)payload);
                    GemSpecification gemSpecification = GemSpecificationUtils.retrieveGemSpecification((InputStreamSupplier)tempBlob);
                    GemCoordinate coordinates = gemSpecification.getCoordinate();
                    String path = StringUtils.prependIfMissing((String)coordinates.gemPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
                    this.ensurePermitted(repository.getName(), "rubygems", path, this.coordinatesToMap(coordinates));
                    content = ((RubygemsHostedFacet)repository.facet(RubygemsHostedFacet.class)).putGem(RubygemsFile.create(coordinates.gemPath(), new String[0]), (Payload)new TempBlobPayload(tempBlob));
                    if (tempBlob == null) break block15;
                    tempBlob.close();
                }
                if (payload == null) break block16;
                payload.close();
            }
            return content;
            {
                catch (Throwable throwable2) {
                    try {
                        if (tempBlob != null) {
                            tempBlob.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (payload != null) {
                            payload.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinition("rubygems", false);
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }

    public boolean supportsExportImport() {
        return true;
    }

    private Map<String, String> coordinatesToMap(GemCoordinate coordinates) {
        return ImmutableMap.of((Object)"name", (Object)coordinates.getName(), (Object)"version", (Object)coordinates.getVersion());
    }
}

