/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems;

import com.google.common.base.Preconditions;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsConstants;

public class RubygemsFile
extends ComponentSupport
implements GroovyObject {
    public static final String INTERNAL_DEPENDENCIES = "dependencies";
    public static final String API_V1_DEPENDENCIES = "api/v1/dependencies";
    public static final String API_VERSIONS = "versions";
    public static final String API_GEM_INFO = "info/";
    public static final String API_V1_GEMS = "api/v1/gems";
    public static final String GEMS = "gems";
    public static final String GEM_SUFFIX = ".gem";
    public static final String SPECS_4_8 = "specs.4.8";
    public static final String SPECS_4_8_GZ;
    public static final String LATEST_SPECS_4_8_GZ;
    public static final String PRERELEASE_SPECS_4_8_GZ;
    public static final String API_PREFIX = "api/";
    public static final String GZ_SUFFIX = ".gz";
    public static final String RUBY_SUFFIX = ".ruby";
    private final GemCoordinate coordinate;
    private final AssetKind kind;
    private final String path;
    private final List<String> gems;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    private RubygemsFile(GemCoordinate coordinate, AssetKind kind, String path, String ... gems) {
        String string;
        AssetKind assetKind;
        GemCoordinate gemCoordinate;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.coordinate = gemCoordinate = coordinate;
        this.kind = assetKind = kind;
        this.path = string = path;
        List<Object> list = gems == null ? null : Arrays.asList((Object[])ScriptBytecodeAdapter.castToType((Object)gems, Object[].class));
        this.gems = (List)ScriptBytecodeAdapter.castToType(list, List.class);
    }

    private RubygemsFile(AssetKind kind, String path) {
        this(null, kind, path, null);
    }

    private RubygemsFile(GemCoordinate coordinate, AssetKind kind, String path) {
        this(coordinate, kind, path, null);
    }

    private RubygemsFile(AssetKind kind, String path, String ... gems) {
        this(null, kind, path, gems);
    }

    public static RubygemsFile create(String path, String ... gems) {
        if (path.startsWith("/")) {
            String string;
            path = string = path.substring(1);
        }
        GemCoordinate coordinate = GemCoordinate.fromPath(path);
        if (coordinate != null) {
            Preconditions.checkArgument((gems == null || gems.length == 0 ? 1 : 0) != 0, (String)"Expected the list of gems for path %s to be null or empty, but was %s", (Object)path, (Object)DefaultGroovyMethods.toString((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)gems, Object[].class))));
            if (path.endsWith(GEM_SUFFIX)) {
                return new RubygemsFile(coordinate, AssetKind.GEM, coordinate.gemPath());
            }
            return new RubygemsFile(coordinate, AssetKind.GEMSPEC, coordinate.gemspecPath());
        }
        if (API_V1_DEPENDENCIES.equals(path) || INTERNAL_DEPENDENCIES.equals(path)) {
            return new RubygemsFile(AssetKind.BUNDLER_API_DEPENDENCIES, path, gems);
        }
        if (API_VERSIONS.equals(path)) {
            return new RubygemsFile(AssetKind.VERSIONS, path, gems);
        }
        if (path.startsWith(API_GEM_INFO)) {
            Matcher matcher = RubygemsConstants.GEM_INFO_MATCHER.matcher(path);
            if (!matcher.matches()) {
                throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((String)"Unable to parse geminfo path: ", (CharSequence)path));
            }
            return new RubygemsFile(AssetKind.GEM_INFO, path, matcher.group("gem"));
        }
        if (path.startsWith(API_V1_DEPENDENCIES) && path.endsWith(RUBY_SUFFIX)) {
            return RubygemsFile.getDependencyRubygemsFile(path, API_V1_DEPENDENCIES);
        }
        if (path.startsWith(INTERNAL_DEPENDENCIES) && path.endsWith(RUBY_SUFFIX)) {
            return RubygemsFile.getDependencyRubygemsFile(path, INTERNAL_DEPENDENCIES);
        }
        if (API_V1_GEMS.equals(path)) {
            return new RubygemsFile(AssetKind.GEM, path);
        }
        if (path.startsWith(API_PREFIX)) {
            String string;
            path = string = path.substring(4);
        }
        if (path.equals(SPECS_4_8_GZ) || path.equals(LATEST_SPECS_4_8_GZ) || path.equals(PRERELEASE_SPECS_4_8_GZ)) {
            return new RubygemsFile(AssetKind.SPECS_INDEX, path);
        }
        return (RubygemsFile)((Object)ScriptBytecodeAdapter.castToType(null, RubygemsFile.class));
    }

    private static RubygemsFile getDependencyRubygemsFile(String path, String prefix) {
        String gem = path.substring(prefix.length() + 1, path.lastIndexOf(RUBY_SUFFIX));
        return new RubygemsFile(AssetKind.BUNDLER_API_DEPENDENCIES, prefix, gem);
    }

    @Nullable
    public GemCoordinate getCoordinate() {
        return this.coordinate;
    }

    @Nonnull
    public AssetKind getKind() {
        return this.kind;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public String getUrl() {
        StringBuilder path = new StringBuilder(this.path);
        if (this.gems != null) {
            path.append("?gems=");
            StringJoiner sj = new StringJoiner(",");
            String gem = null;
            Iterator<String> iterator = this.gems.iterator();
            while (iterator.hasNext()) {
                gem = ShortTypeHandling.castToString((Object)iterator.next());
                try {
                    sj.add(URLEncoder.encode(gem, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    this.log.error("Failed to encode gem string: {}", (Object)gem, (Object)e);
                    throw (Throwable)new RuntimeException(e);
                }
            }
            path.append(sj);
        }
        return path.toString();
    }

    @Nullable
    public List<String> getGems() {
        return this.gems;
    }

    public String toString() {
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)"RubygemsFile{", (CharSequence)"coordinate="), (Object)this.coordinate), (CharSequence)", kind="), (Object)((Object)this.kind)), (CharSequence)", path='"), (CharSequence)this.path), (CharSequence)"'"), (CharSequence)", gems="), this.gems), (CharSequence)"}");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != RubygemsFile.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        String string;
        String string2;
        String string3;
        SPECS_4_8_GZ = string3 = StringGroovyMethods.plus((String)SPECS_4_8, (CharSequence)GZ_SUFFIX);
        LATEST_SPECS_4_8_GZ = string2 = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"latest_", (CharSequence)SPECS_4_8), (CharSequence)GZ_SUFFIX);
        PRERELEASE_SPECS_4_8_GZ = string = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"prerelease_", (CharSequence)SPECS_4_8), (CharSequence)GZ_SUFFIX);
    }
}

