/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonatype.nexus.blobstore.restore.RubygemsRestoreBlobData;
import com.sonatype.nexus.blobstore.restore.RubygemsRestoreBlobDataFactory;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.orient.OrientBaseRestoreBlobStrategy;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.orient.OrientRubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.orient.OrientRubygemsRepairMetadata;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Query;

@Named(value="rubygems")
@Singleton
public class OrientRubygemsRestoreBlobStrategy
extends OrientBaseRestoreBlobStrategy<RubygemsRestoreBlobData> {
    private final RubygemsRestoreBlobDataFactory rubygemsRestoreBlobDataFactory;
    private final OrientRubygemsRepairMetadata rubygemsRepairMetadata;

    @Inject
    public OrientRubygemsRestoreBlobStrategy(NodeAccess nodeAccess, RepositoryManager repositoryManager, DryRunPrefix dryRunPrefix, RubygemsRestoreBlobDataFactory rubygemsRestoreBlobDataFactory, OrientRubygemsRepairMetadata rubygemsRepairMetadata) {
        super(nodeAccess, repositoryManager, dryRunPrefix);
        this.rubygemsRestoreBlobDataFactory = (RubygemsRestoreBlobDataFactory)Preconditions.checkNotNull((Object)rubygemsRestoreBlobDataFactory);
        this.rubygemsRepairMetadata = (OrientRubygemsRepairMetadata)Preconditions.checkNotNull((Object)rubygemsRepairMetadata);
    }

    protected RubygemsRestoreBlobData createRestoreData(RestoreBlobData blobData) {
        return this.rubygemsRestoreBlobDataFactory.create(blobData);
    }

    protected boolean canAttemptRestore(@Nonnull RubygemsRestoreBlobData data) {
        Repository repository = data.getBlobData().getRepository();
        Optional rubygemsContentFacet = repository.optionalFacet(OrientRubygemsContentFacet.class);
        if (!rubygemsContentFacet.isPresent()) {
            this.log.warn("Skipping as RubygemsContentFacet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected String getAssetPath(@Nonnull RubygemsRestoreBlobData data) {
        return data.getPath();
    }

    protected boolean assetExists(@Nonnull RubygemsRestoreBlobData data) {
        RestoreBlobData blobData = data.getBlobData();
        Repository repository = blobData.getRepository();
        OrientRubygemsContentFacet rubygemsContentFacet = (OrientRubygemsContentFacet)repository.facet(OrientRubygemsContentFacet.class);
        return rubygemsContentFacet.assetExists(blobData.getBlobName());
    }

    protected void createAssetFromBlob(@Nonnull AssetBlob assetBlob, @Nonnull RubygemsRestoreBlobData restoreBlobData) throws IOException {
        Repository repository = restoreBlobData.getBlobData().getRepository();
        OrientRubygemsContentFacet facet = (OrientRubygemsContentFacet)repository.facet(OrientRubygemsContentFacet.class);
        switch (restoreBlobData.getAssetKind()) {
            case GEM: {
                facet.restoreGem(restoreBlobData.getGemCoordinate(), assetBlob);
                break;
            }
            case GEMSPEC: {
                facet.restoreGemSpec(restoreBlobData.getGemCoordinate(), assetBlob);
                break;
            }
            case BUNDLER_API_DEPENDENCIES: {
                facet.restoreBundlerApi(restoreBlobData.getPath(), assetBlob);
                break;
            }
            case SPECS_INDEX: {
                facet.restoreSpecsIndex(restoreBlobData.getPath(), assetBlob);
                break;
            }
            case GEM_INFO: 
            case VERSIONS: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Nonnull
    protected List<HashAlgorithm> getHashAlgorithms() {
        return Lists.newArrayList((Object[])new HashAlgorithm[]{HashAlgorithm.SHA1, HashAlgorithm.MD5});
    }

    public void after(boolean updateAssets, Repository repository) {
        if (updateAssets) {
            this.rubygemsRepairMetadata.repairRepository(repository);
        } else {
            this.log.info("Updating assets disabled so not running repair of Rubygems metadata");
        }
    }

    protected boolean componentRequired(@Nonnull RubygemsRestoreBlobData data) throws IOException {
        AssetKind assetKind = data.getAssetKind();
        return assetKind.equals((Object)AssetKind.GEM) || assetKind.equals((Object)AssetKind.GEMSPEC);
    }

    protected Query getComponentQuery(@Nonnull RubygemsRestoreBlobData data) {
        GemCoordinate coordinate = data.getGemCoordinate();
        return Query.builder().where("name").eq((Object)coordinate.getName()).and("version").eq((Object)coordinate.getGemVersion().getVersion()).build();
    }

    protected Repository getRepository(@Nonnull RubygemsRestoreBlobData data) {
        return data.getBlobData().getRepository();
    }
}

