/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.datastore;

import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.datastore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.datastore.DataStoreRestoreBlobData;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.RubygemsRepairMetadata;
import org.sonatype.nexus.repository.rubygems.datastore.RubygemsContentFacet;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.DetachedBlobPayload;

@Singleton
@Named(value="rubygems")
public class RubygemsRestoreBlobStrategy
extends BaseRestoreBlobStrategy<DataStoreRestoreBlobData> {
    private final RepositoryManager repositoryManager;
    private final RubygemsRepairMetadata rubygemsRepairMetadata;

    @Inject
    protected RubygemsRestoreBlobStrategy(DryRunPrefix dryRunPrefix, RepositoryManager repositoryManager, RubygemsRepairMetadata rubygemsRepairMetadata) {
        super(dryRunPrefix);
        this.repositoryManager = repositoryManager;
        this.rubygemsRepairMetadata = rubygemsRepairMetadata;
    }

    protected boolean canAttemptRestore(@Nonnull DataStoreRestoreBlobData data) {
        Repository repository = data.getRepository();
        if (!repository.optionalFacet(RubygemsContentFacet.class).isPresent()) {
            this.log.warn("Skipping as Rubygems Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected void createAssetFromBlob(Blob assetBlob, DataStoreRestoreBlobData data) throws IOException {
        RubygemsContentFacet facet = (RubygemsContentFacet)data.getRepository().facet(RubygemsContentFacet.class);
        String blobName = data.getBlobName();
        AssetKind assetKind = AssetKind.matching(blobName);
        DetachedBlobPayload payload = new DetachedBlobPayload(data.getBlob());
        switch (assetKind) {
            case GEM: {
                facet.putGem((Payload)payload);
                break;
            }
            case GEMSPEC: {
                facet.putGemSpec((Payload)payload);
                break;
            }
            case BUNDLER_API_DEPENDENCIES: 
            case SPECS_INDEX: {
                facet.restoreAsset(blobName, assetKind, (Payload)payload);
                break;
            }
            case GEM_INFO: 
            case VERSIONS: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected String getAssetPath(@Nonnull DataStoreRestoreBlobData data) {
        return data.getBlobName();
    }

    protected DataStoreRestoreBlobData createRestoreData(Properties properties, Blob blob, BlobStore blobStore) {
        return new DataStoreRestoreBlobData(blob, properties, blobStore, this.repositoryManager);
    }

    protected boolean isComponentRequired(DataStoreRestoreBlobData data) {
        AssetKind assetKind = AssetKind.matching(data.getBlobName());
        return assetKind.equals((Object)AssetKind.GEM) || assetKind.equals((Object)AssetKind.GEMSPEC);
    }

    public void after(boolean updateAssets, Repository repository) {
        if (updateAssets) {
            this.rubygemsRepairMetadata.repairRepository(repository);
        } else {
            this.log.info("Updating assets disabled so not running repair of Rubygems metadata");
        }
    }
}

