/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.internal.orient;

import com.google.common.base.Predicates;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.common.upgrade.Checkpoint;
import org.sonatype.nexus.common.upgrade.Checkpoints;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrade;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.upgrade.internal.orient.InitialStep;
import org.sonatype.nexus.upgrade.internal.orient.UpgradeStep;
import org.sonatype.nexus.upgrade.plan.DependencyResolver;

@Named
@Singleton
public class UpgradeManager
extends ComponentSupport {
    private final BiMap<String, Checkpoint> checkpointIndex;
    private final BiMap<Upgrades, Upgrade> upgradeIndex;
    private final boolean warnOnMissingDependencies;
    private final Set<String> localModels;
    private final Set<String> clusteredModels;

    @Inject
    public UpgradeManager(List<Checkpoint> managedCheckpoints, List<Upgrade> managedUpgrades, @Named(value="${nexus.upgrade.warnOnMissingDependencies:-false}") @Named(value="${nexus.upgrade.warnOnMissingDependencies:-false}") boolean warnOnMissingDependencies) {
        ArrayList<String> problems = new ArrayList<String>();
        this.checkpointIndex = this.indexCheckpoints(managedCheckpoints, problems);
        this.upgradeIndex = this.indexUpgrades(managedUpgrades, problems);
        this.warnOnMissingDependencies = warnOnMissingDependencies;
        if (!problems.isEmpty()) {
            String message = String.format("Found %d problem(s) with upgrades:%n%s", problems.size(), problems.stream().collect(Collectors.joining(System.lineSeparator())));
            throw new IllegalStateException(message);
        }
        this.localModels = this.checkpointIndex.values().stream().map(c -> c.getClass().getAnnotation(Checkpoints.class)).filter(Checkpoints::local).map(Checkpoints::model).collect(Collectors.toSet());
        this.clusteredModels = Stream.concat(this.checkpointIndex.keySet().stream(), this.upgradeIndex.keySet().stream().map(Upgrades::model)).filter(m -> !this.localModels.contains(m)).collect(Collectors.toSet());
    }

    public Set<String> getLocalModels() {
        return this.localModels;
    }

    public Set<String> getClusteredModels() {
        return this.clusteredModels;
    }

    public List<Upgrade> selectUpgrades(Map<String, String> modelVersions, boolean localOnly) {
        List<Upgrade> upgrades = this.upgradeIndex.entrySet().stream().filter(e -> UpgradeManager.applies(modelVersions, (Upgrades)e.getKey())).map(e -> (Upgrade)e.getValue()).collect(Collectors.toList());
        ArrayList problems = new ArrayList();
        upgrades.forEach(u -> this.checkUpgrade((Upgrade)u, problems));
        if (!problems.isEmpty()) {
            String message = String.format("Found %d problem(s) with upgrades:%n%s", problems.size(), problems.stream().collect(Collectors.joining(System.lineSeparator())));
            throw new IllegalStateException(message);
        }
        Stream<UpgradeStep> upgradeSteps = this.order(modelVersions, upgrades);
        if (localOnly) {
            upgradeSteps = upgradeSteps.filter(step -> this.localModels.contains(step.getModel()));
        }
        return upgradeSteps.map(UpgradeStep::getUpgrade).collect(Collectors.toList());
    }

    public List<Checkpoint> selectCheckpoints(List<Upgrade> upgrades) {
        HashSet candidates = new HashSet(this.checkpointIndex.keySet());
        return upgrades.stream().flatMap(u -> this.filterModelDependencies((Upgrade)u, DependsOn::checkpoint)).filter(candidates::remove).map(arg_0 -> this.checkpointIndex.get(arg_0)).collect(Collectors.toList());
    }

    public Map<String, String> latestKnownModelVersions() {
        return this.upgradeIndex.keySet().stream().collect(Collectors.groupingBy(Upgrades::model, Collectors.collectingAndThen(Collectors.maxBy(UpgradeManager::byVersion), step -> ((Upgrades)step.get()).to())));
    }

    public String getModel(Checkpoint checkpoint) {
        return (String)this.checkpointIndex.inverse().get((Object)checkpoint);
    }

    public Upgrades getMetadata(Upgrade upgrade) {
        return (Upgrades)this.upgradeIndex.inverse().get((Object)upgrade);
    }

    private BiMap<String, Checkpoint> indexCheckpoints(List<Checkpoint> checkpoints, List<String> problems) {
        Map<String, List<Checkpoint>> byName = checkpoints.stream().collect(Collectors.groupingBy(c -> c.getClass().isAnnotationPresent(Checkpoints.class) ? c.getClass().getAnnotation(Checkpoints.class).model() : null));
        if (byName.containsKey(null)) {
            byName.remove(null).stream().map(c -> String.format("Checkpoint %s is not annotated with @Checkpoints", UpgradeManager.className(c))).collect(Collectors.toCollection(() -> problems));
        }
        byName.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(e -> String.format("Checkpoint of model: %s duplicated by classes: %s", e.getKey(), UpgradeManager.classNames((List)e.getValue()))).collect(Collectors.toCollection(() -> problems));
        return (BiMap)byName.entrySet().stream().collect(ImmutableBiMap.toImmutableBiMap(e -> (String)e.getKey(), e -> (Checkpoint)((List)e.getValue()).get(0)));
    }

    private BiMap<Upgrades, Upgrade> indexUpgrades(List<Upgrade> upgrades, List<String> problems) {
        Map<Upgrades, List<Upgrade>> byAnnotation = upgrades.stream().collect(Collectors.groupingBy(c -> c.getClass().getAnnotation(Upgrades.class)));
        if (byAnnotation.containsKey(null)) {
            byAnnotation.remove(null).stream().map(c -> String.format("Upgrade step %s is not annotated with @Upgrades", UpgradeManager.className(c))).collect(Collectors.toCollection(() -> problems));
        }
        byAnnotation.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(e -> String.format("Upgrade of model: %s from: %s to: %s duplicated by classes: %s", ((Upgrades)e.getKey()).model(), ((Upgrades)e.getKey()).from(), ((Upgrades)e.getKey()).to(), UpgradeManager.classNames((List)e.getValue()))).collect(Collectors.toCollection(() -> problems));
        return (BiMap)byAnnotation.entrySet().stream().collect(ImmutableBiMap.toImmutableBiMap(e -> (Upgrades)e.getKey(), e -> (Upgrade)((List)e.getValue()).get(0)));
    }

    private void checkUpgrade(Upgrade upgrade, List<String> problems) {
        Upgrades metadata = this.getMetadata(upgrade);
        if (VersionComparator.INSTANCE.compare(metadata.to(), metadata.from()) <= 0) {
            problems.add(String.format("Upgrade step %s has invalid version: %s is not after %s", UpgradeManager.className(upgrade), metadata.to(), metadata.from()));
        }
        Set<String> modelDependencies = this.findModelDependencies(upgrade);
        Set<String> injectedDependencies = this.findInjectedDependencies(upgrade);
        Sets.SetView undeclaredModels = Sets.difference(injectedDependencies, modelDependencies);
        if (!undeclaredModels.isEmpty()) {
            String message = String.format("Upgrade step %s has undeclared model dependencies: %s", UpgradeManager.className(upgrade), undeclaredModels);
            if (this.warnOnMissingDependencies) {
                this.log.warn(message);
            } else {
                problems.add(message);
            }
        }
        if (this.selectCheckpoints(Arrays.asList(upgrade)).isEmpty()) {
            problems.add(String.format("Upgrade step %s does not trigger a checkpoint", UpgradeManager.className(upgrade)));
        }
    }

    private Set<String> findModelDependencies(Upgrade upgrade) {
        return this.filterModelDependencies(upgrade, (Predicate<DependsOn>)Predicates.alwaysTrue()).collect(Collectors.toSet());
    }

    private Stream<String> filterModelDependencies(Upgrade upgrade, Predicate<DependsOn> dependsOnFilter) {
        return Stream.concat(Stream.of(this.getMetadata(upgrade).model()), Stream.of((DependsOn[])upgrade.getClass().getAnnotationsByType(DependsOn.class)).filter(dependsOnFilter).map(DependsOn::model));
    }

    private Set<String> findInjectedDependencies(Upgrade upgrade) {
        Optional<Constructor<?>> injectedConstructor = this.findInjectedConstructor(upgrade);
        if (!injectedConstructor.isPresent()) {
            return ImmutableSet.of();
        }
        return Stream.of(injectedConstructor.get().getParameters()).filter(p -> p.isAnnotationPresent(Named.class)).map(p -> p.getAnnotation(Named.class).value()).filter(d -> this.clusteredModels.contains(d) || this.localModels.contains(d)).collect(Collectors.toSet());
    }

    private Optional<Constructor<?>> findInjectedConstructor(Upgrade upgrade) {
        return Stream.of(upgrade.getClass().getDeclaredConstructors()).filter(c -> c.isAnnotationPresent(Inject.class)).findFirst();
    }

    private Stream<UpgradeStep> order(Map<String, String> modelVersions, List<Upgrade> upgrades) {
        DependencyResolver resolver = new DependencyResolver();
        resolver.setWarnOnMissingDependencies(this.warnOnMissingDependencies);
        resolver.add(ImmutableList.of((Object)new InitialStep(modelVersions)));
        resolver.add(upgrades.stream().map(UpgradeStep::new).sorted(UpgradeManager::byVersion).collect(Collectors.toList()));
        return resolver.resolve().getOrdered().stream().map(UpgradeStep::unwrap).filter(Objects::nonNull);
    }

    private static boolean applies(Map<String, String> modelVersions, Upgrades metadata) {
        String current = modelVersions.getOrDefault(metadata.model(), "1.0");
        return VersionComparator.INSTANCE.compare(metadata.to(), current) > 0;
    }

    private static int byVersion(UpgradeStep lhs, UpgradeStep rhs) {
        return VersionComparator.INSTANCE.compare(lhs.getVersion(), rhs.getVersion());
    }

    private static int byVersion(Upgrades lhs, Upgrades rhs) {
        return VersionComparator.INSTANCE.compare(lhs.to(), rhs.to());
    }

    private static String className(Object element) {
        return element.getClass().getCanonicalName();
    }

    private static String classNames(List<?> elements) {
        return elements.stream().map(UpgradeManager::className).collect(Collectors.joining(", "));
    }
}

