/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.property.PropertiesFile;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.upgrade.internal.orient.ClusteredModelVersions;
import org.sonatype.nexus.upgrade.internal.orient.ClusteredModelVersionsEntityAdapter;
import org.sonatype.nexus.upgrade.internal.orient.UpgradeManager;

@Named
@Singleton
public class ModelVersionStore
extends StateGuardLifecycleSupport {
    @VisibleForTesting
    static final String MODEL_PROPERTIES = "model.properties";
    private final UpgradeManager upgradeManager;
    private final Provider<DatabaseInstance> databaseInstance;
    private final ClusteredModelVersionsEntityAdapter entityAdapter;
    private final PropertiesFile localModelVersions;
    private ClusteredModelVersions clusteredModelVersions;
    private boolean newInstance;

    @Inject
    public ModelVersionStore(UpgradeManager upgradeManager, @Named(value="config") @Named(value="config") Provider<DatabaseInstance> databaseInstance, ClusteredModelVersionsEntityAdapter entityAdapter, ApplicationDirectories applicationDirectories) {
        this.upgradeManager = (UpgradeManager)((Object)Preconditions.checkNotNull((Object)((Object)upgradeManager)));
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (ClusteredModelVersionsEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
        this.localModelVersions = new PropertiesFile(new File(applicationDirectories.getWorkDirectory("db"), MODEL_PROPERTIES));
    }

    protected void doStart() throws Exception {
        if (this.localModelVersions.exists()) {
            this.localModelVersions.load();
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db, () -> {
                boolean bl = this.newInstance = !db.getMetadata().getSchema().existsClass("repository");
            });
            this.clusteredModelVersions = this.entityAdapter.get(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Guarded(by={"STARTED"})
    public boolean isNewInstance() {
        return this.newInstance;
    }

    @Guarded(by={"STARTED"})
    public synchronized Map<String, String> load() {
        HashMap<String, String> modelVersions = new HashMap<String, String>();
        this.load(modelVersions, this.upgradeManager.getLocalModels(), arg_0 -> this.localModelVersions.getProperty(arg_0));
        this.load(modelVersions, this.upgradeManager.getClusteredModels(), this.clusteredModelVersions::get);
        return modelVersions;
    }

    private void load(Map<String, String> mergedModelVersions, Set<String> models, Function<String, String> versionLookup) {
        for (String model : models) {
            String version = versionLookup.apply(model);
            if (version == null) continue;
            mergedModelVersions.put(model, version);
        }
    }

    @Guarded(by={"STARTED"})
    public synchronized void save(Map<String, String> modelVersions) {
        Preconditions.checkNotNull(modelVersions);
        this.save(modelVersions, this.upgradeManager.getLocalModels(), (arg_0, arg_1) -> this.localModelVersions.setProperty(arg_0, arg_1));
        this.save(modelVersions, this.upgradeManager.getClusteredModels(), this.clusteredModelVersions::put);
        try {
            this.localModelVersions.store();
            if (this.clusteredModelVersions.isDirty()) {
                OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
                    boolean bl = this.entityAdapter.set(db, (Entity)this.clusteredModelVersions);
                });
                this.clusteredModelVersions.clearDirty();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save upgraded model versions: " + modelVersions, e);
        }
    }

    private void save(Map<String, String> mergedModelVersions, Set<String> models, BiConsumer<String, String> versionSetter) {
        for (String model : models) {
            String version = mergedModelVersions.get(model);
            if (version == null) continue;
            versionSetter.accept(model, version);
        }
    }
}

